<#ibizinclude>
./WF_VIEW_CONTENT.vue.ftl
</#ibizinclude>

    <#if view.getPSAppViewEngines()??>
    <#list view.getPSAppViewEngines() as engine>
    /**
     * 视图引擎
     *
     * @public
     * @type {Engine}
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public ${engine.getName()?lower_case}: ${engine.getEngineType()}Engine = new ${engine.getEngineType()}Engine();
    </#list>
    </#if>

    /**
     * 引擎初始化
     *
     * @public
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public engineInit(): void {
    <#if view.getPSAppViewEngines()??>
    <#list view.getPSAppViewEngines() as engine>
        this.${engine.getName()?lower_case}.init({
            view: this,
        <#if engine.getPSAppViewEngineParams()??>
            <#list engine.getPSAppViewEngineParams() as param>
            <#if param.getParamType() == "LOGIC" && param.getPSAppViewLogic()??>
            ${param.getName()?lower_case}: (args: any[],fullargs?:any[],params?: any, $event?: any, xData?: any) => {
                this.${param.getPSAppViewLogic().getName()}(args,fullargs, params, $event, xData);
            },
            </#if>
            <#if param.getParamType() == "CTRL" && param.getPSControl()??>
            ${param.getName()?lower_case}: this.$refs.${param.getPSControl().getName()},
            </#if>
            <#if param.getParamType() == "VALUE" && param.getValue()??>
            ${param.getName()?lower_case}: '${param.getValue()?c}',
            </#if>
            </#list>
        </#if>
        <#if de??>
            keyPSDEField: '${appde.getCodeName()?lower_case}',
            <#if appde.getMajorPSAppDEField()??>
            majorPSDEField: '${appde.getMajorPSAppDEField().getCodeName()?lower_case}',
            </#if>
        </#if>
            isLoadDefault: <#if view.isLoadDefault?? && !view.isLoadDefault()>false<#else>true</#if>,
        });
    </#list>
    </#if>
    }

    /**
     * 应用导航服务
     *
     * @type {*}
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public  navDataService = NavDataService.getInstance(this.$store);

    /**
    * 导航服务事件
    *
    * @public
    * @type {(Subscription | undefined)}
    * @memberof ${srfclassname('${view.name}')}Base
    */
    public serviceStateEvent: Subscription | undefined;

    /**
     * 应用上下文
     *
     * @type {*}
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public context:any = {};

    /**
     * 视图参数
     *
     * @type {*}
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public viewparams:any = {};

    /**
     * 视图缓存数据
     *
     * @type {*}
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public viewCacheData:any;

    /**
     * 解析视图参数
     *
     * @public
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public parseViewParam(inputvalue:any = null): void {
        for(let key in this.context){
            delete this.context[key];
        }
        if (!this.viewDefaultUsage && this.viewdata && !Object.is(this.viewdata, '')) {
            Object.assign(this.context, JSON.parse(this.viewdata));
            if(this.context && this.context.srfparentdename){
                Object.assign(this.viewparams,{srfparentdename:this.context.srfparentdename});
            }
            if(this.context && this.context.srfparentkey){
                Object.assign(this.viewparams,{srfparentkey:this.context.srfparentkey});
            }
            if(this.$store.getters.getAppData() && this.$store.getters.getAppData().context){
                Object.assign(this.context,this.$store.getters.getAppData().context);
            }
            this.handleCustomViewData();
            <#if self_viewparam??>
            ${self_viewparam}
            </#if>
            return;
        }
        const path = (this.$route.matched[this.$route.matched.length - 1]).path;
        const keys: Array<any> = [];
        const curReg = this.$pathToRegExp.pathToRegexp(path, keys);
        const matchArray = curReg.exec(this.$route.path);
        let tempValue: Object = {};
        keys.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item.name, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
        this.$viewTool.formatRouteParams(tempValue,this.$route,this.context,this.viewparams);
        <#if appde??>
        if(inputvalue){
            Object.assign(this.context,{'${appde.getCodeName()?lower_case}':inputvalue});
        }
        </#if>
        if(this.$store.getters.getAppData() && this.$store.getters.getAppData().context){
            Object.assign(this.context,this.$store.getters.getAppData().context);
        }
        <#if view.isPSDEView()>
        //初始化视图唯一标识
        Object.assign(this.context,{srfsessionid:this.$util.createUUID()});
        </#if>
        this.handleCustomViewData();
        //初始化导航数据
        this.initNavDataWithRoute();
    }

    /**
     * 处理自定义视图数据
     *
     * @memberof ${srfclassname('${view.name}')}Base
     */
	public handleCustomViewData(){
        <#if view.getPSDER1N?? && view.getPSDER1N()??>
        this.handleviewRes();
        </#if>
		if(Object.keys(this.customViewNavContexts).length > 0){
			Object.keys(this.customViewNavContexts).forEach((item:any) =>{
				let tempContext:any = {};
				let curNavContext:any = this.customViewNavContexts[item];
				this.handleCustomDataLogic(curNavContext,tempContext,item);
				Object.assign(this.context,tempContext);
			})
		}
		if(Object.keys(this.customViewParams).length > 0){
			Object.keys(this.customViewParams).forEach((item:any) =>{
				let tempParam:any = {};
				let curNavParam:any = this.customViewParams[item];
				this.handleCustomDataLogic(curNavParam,tempParam,item);
				Object.assign(this.viewparams,tempParam);
			})
		}
	}

    /**
     * 处理自定义视图数据逻辑
     *
     * @memberof ${srfclassname('${view.name}')}Base
     */
	public handleCustomDataLogic(curNavData:any,tempData:any,item:string){
		// 直接值直接赋值
		if(curNavData.isRawValue){
			if(Object.is(curNavData.value,"null") || Object.is(curNavData.value,"")){
                Object.defineProperty(tempData, item.toLowerCase(), {
                    value: null,
                    writable : true,
                    enumerable : true,
                    configurable : true
                });
            }else{
                Object.defineProperty(tempData, item.toLowerCase(), {
                    value: curNavData.value,
                    writable : true,
                    enumerable : true,
                    configurable : true
                });
            }
		}else{
			// 先从导航上下文取数，没有再从导航参数（URL）取数，如果导航上下文和导航参数都没有则为null
			if(this.context[(curNavData.value).toLowerCase()] != null){
				Object.defineProperty(tempData, item.toLowerCase(), {
					value: this.context[(curNavData.value).toLowerCase()],
					writable : true,
					enumerable : true,
					configurable : true
				});
			}else{
				if(this.viewparams[(curNavData.value).toLowerCase()] != null){
					Object.defineProperty(tempData, item.toLowerCase(), {
						value: this.viewparams[(curNavData.value).toLowerCase()],
						writable : true,
						enumerable : true,
						configurable : true
					});
				}else{
					Object.defineProperty(tempData, item.toLowerCase(), {
						value: null,
						writable : true,
						enumerable : true,
						configurable : true
					});
				}
			}
		}
	}

    /**
     * 初始化导航数据(路由模式)
     *
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public initNavDataWithRoute(data:any = null, isNew:boolean = false,  isAlways:boolean = false){
        if( isAlways || (this.viewDefaultUsage && Object.is(this.navModel,"route")) ){
            this.navDataService.addNavData({id:'${srffilepath2(view.getCodeName())}',tag:this.viewtag,srfkey:isNew ? null : <#if appde??>this.context.${appde.getCodeName()?lower_case}<#else>null</#if>,title:this.$t(this.model.srfTitle),data:data,context:this.context,viewparams:this.viewparams,path:this.$route.fullPath});
        }
    }

    /**
     * 初始化导航数据(分页模式)
     *
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public initNavDataWithTab(data:any = null,isOnlyAdd:boolean = true, isAlways:boolean = false){
        if( isAlways || (this.viewDefaultUsage && !Object.is(this.navModel,"route")) ){
            this.navDataService.addNavDataByOnly({id:'${srffilepath2(view.getCodeName())}',tag:this.viewtag,srfkey:<#if appde??>this.context.${appde.getCodeName()?lower_case}<#else>null</#if>,title:this.$t(this.model.srfTitle),data:data,context:this.context,viewparams:this.viewparams,path:this.$route.fullPath},isOnlyAdd);
        }
    }
	
    <#if view.getPSDER1N?? && view.getPSDER1N()??>
    /**
     * 处理指定视图控制关系将父键转为父实体上下文
     *
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public handleviewRes(){
    <#assign viewRes = view.getPSDER1N()/>
    <#if viewRes.getMajorPSDataEntity()??>
    <#assign majorAppDataEntity = viewRes.getMajorPSDataEntity() />
    if(this.context.srfparentkey){
        Object.assign(this.context,{'${majorAppDataEntity.getCodeName()?lower_case}':this.context.srfparentkey});
    }
    </#if>
    }
    </#if>

    /**
     * Vue声明周期
     *
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public created() {
        this.afterCreated();
    }

    /**
     * 执行created后的逻辑
     *
     * @memberof ${srfclassname('${view.name}')}Base
     */    
    public afterCreated(){
        let _this:any = this;
        const secondtag = _this.$util.createUUID();
        _this.$store.commit('viewaction/createdView', { viewtag: _this.viewtag, secondtag: secondtag });
        _this.viewtag = secondtag;
        _this.parseViewParam();
        _this.serviceStateEvent = _this.navDataService.serviceState.subscribe(({ action,name, data }:{ action:string,name:any,data:any }) => {
            if(!Object.is(name,'${srffilepath2(view.getCodeName())}')){
                return;
            }
            if (Object.is(action, 'viewrefresh')) {
                _this.$nextTick(()=>{
                    _this.parseViewParam(data);
                    if(_this.engine){
                        _this.engine.load();
                    }
                }); 
            }
        });
        <#if created_block??>${created_block}</#if>
    }

    /**
     * 销毁之前
     *
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public beforeDestroy() {
        this.$store.commit('viewaction/removeView', this.viewtag);
    }

    /**
     * Vue声明周期(组件初始化完毕)
     *
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public mounted() {
        this.afterMounted();
    }

    /**
     * 执行mounted后的逻辑
     * 
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public afterMounted(){
        const _this: any = this;
        <#if view.getPSAppViewEngines()??>
        _this.engineInit();
        </#if>
        if (_this.loadModel && _this.loadModel instanceof Function) {
            _this.loadModel();
        }
        <#if mounted_block??>${mounted_block}</#if>
    }

    <#if view.getPSControls()??>
    <#list view.getPSControls() as ctrl>
    <#if ctrl.getControlType()??>
    <#if ctrl.getHookEventNames()??>
    <#list ctrl.getHookEventNames() as eventName>

    /**
     * ${ctrl.name} 部件 ${eventName?lower_case} 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public ${ctrl.name}_${eventName?lower_case}($event: any, $event2?: any) {
    <#if ctrl.getPSControlLogics(eventName)??>
    <#list ctrl.getPSControlLogics(eventName) as ctrlLogic>
    <#if ctrlLogic.getLogicType() == "APPVIEWENGINE" && ctrlLogic.getPSAppViewEngine()??>
        this.${ctrlLogic.getPSAppViewEngine().getName()}.onCtrlEvent('${ctrl.name}', '${eventName?lower_case}', $event);
    <#else>
        <#if ctrlLogic.getEventArg()?? && ctrlLogic.getEventArg()?length gt 0>
        if (Object.is($event.tag, '${ctrlLogic.getEventArg()}')) {
            this.${ctrlLogic.name}(null, '', $event2);
        }
        <#else>
        this.${ctrlLogic.name}($event, '', $event2);
        </#if>
    </#if>
    </#list>
    </#if>
    }

    </#list>
    </#if>
    </#if>
    </#list>
    </#if>

<#if view.getPSAppViewLogics()??>
<#list view.getPSAppViewLogics() as logic>
<#if logic.getLogicTrigger() == "CUSTOM" || logic.getLogicTrigger() == "CTRLEVENT">

${P.getLogicCode(logic, "LOGIC.vue").code}
</#if>
</#list>
</#if>

<#if view.getPSAppViewUIActions()??>
<#list view.getPSAppViewUIActions() as viewUIAction>
<#if viewUIAction.getPSUIAction()?? >
<#assign uiAction = viewUIAction.getPSUIAction()/>
<#if !P.exists("importService", uiAction.getFullCodeName(), "")>
<#-- 系统预置界面行为输入start -->
<#if !(uiAction.getPSAppDataEntity?? && uiAction.getPSAppDataEntity()??)>
${P.getLogicCode(uiAction, "LOGIC.vue").code}
</#if>
<#-- 系统预置界面行为输入end -->
</#if>
</#if>
</#list>
</#if>

    /**
     * 关闭视图
     *
     * @param {any[]} args
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public closeView(args: any[]): void {
        let _view: any = this;
        if (_view.viewdata) {
            _view.$emit('viewdataschange', [args]);
            _view.$emit('close', [args]);
        } else if (_view.$tabPageExp) {
            _view.$tabPageExp.onClose(_view.$route.fullPath);
        }
    }
    <#if view.isPSDEView()>
    <#if view.getPSAppDataEntity()??>
    <#assign appDataEntity = view.getPSAppDataEntity() />
    <#if appDataEntity.isMajor()>

    /**
     * 销毁视图回调
     *
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public destroyed(){
        this.afterDestroyed();
    }

    /**
     * 执行destroyed后的逻辑
     * 
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public afterDestroyed(){
        if(this.viewDefaultUsage){
            let localStoreLength = Object.keys(localStorage);
            if(localStoreLength.length > 0){
                localStoreLength.forEach((item:string) =>{
                if(item.startsWith(this.context.srfsessionid)){
                    localStorage.removeItem(item);
                }
                })
            }
            if(Object.is(this.navModel,"tab")){
                this.navDataService.removeNavDataByTag(this.viewtag);
            }
            if (this.serviceStateEvent) {
                this.serviceStateEvent.unsubscribe();
            }
        }
    }
    </#if>
    </#if>
    </#if>
    <#--  视图独立定义的内容start  -->
    <#if self_content??>
    ${self_content}
    </#if>
    <#--  视图独立定义的内容end  -->