
<#ibizinclude>
./LAYOUTPANEL_VIEW.template.ftl
</#ibizinclude>

<#assign import_block>
import CodeListService from "@service/app/codelist-service";
<#if view.getPSSysCounterRef?? && view.getPSSysCounterRef()?? && view.getPSSysCounterRef().getPSAppCounter()??>
<#assign appCounter = view.getPSSysCounterRef().getPSAppCounter() />
import  ${srfclassname('${appCounter.getCodeName()}')}CounterService  from '@/counter/${srffilepath2(appCounter.getCodeName())}/${srffilepath2(appCounter.getCodeName())}-counter';
</#if>
</#assign>

<#ibizinclude>
./VIEW_HEADER-BASE.vue.ftl
</#ibizinclude>

<#assign mounted_block>
<#if view.isEnableQuickGroup()>_this.loadQuickGroupModel();</#if>
</#assign>

<#ibizinclude>
./VIEW_CONTENT-BASE.vue.ftl
</#ibizinclude>

<#if view.hasPSControl('dataview')>
<#assign dataview = view.getPSControl('dataview')>
    /**
     * 是否单选
     *
     * @type {boolean}
     * @memberof ${srfclassname('${view.name}')}
     */
    public isSingleSelect: boolean = ${dataview.isSingleSelect()?c};
</#if>

    /**
     * 视图唯一标识
     *
     * @type {string}
     * @memberof ${srfclassname('${view.name}')}
     */
    public viewUID: string = '${srffilepath2(view.getPSAppModule().getCodeName())}-${srffilepath2(view.getCodeName())}';

    /**
     * 搜索值
     *
     * @type {string}
     * @memberof ${srfclassname('${view.name}')}
     */
    public query: string = '';

    /**
     * 是否展开搜索表单
     *
     * @type {boolean}
     * @memberof ${srfclassname('${view.name}')}
     */
    public isExpandSearchForm: boolean = ${view.isExpandSearchForm()?c};

    /**
     * 快速搜索
     *
     * @param {*} $event
     * @memberof ${srfclassname('${view.name}')}
     */
    public onSearch($event: any): void {
        const refs: any = this.$refs;
        if (refs.dataview) {
            refs.dataview.refresh({});
        }
    }

<#if view.getPSSysCounterRef?? && view.getPSSysCounterRef()?? && view.getPSSysCounterRef().getPSAppCounter()??>
    <#assign appCounter = view.getPSSysCounterRef().getPSAppCounter() />
    /**
     * ${srfclassname('${appCounter.getCodeName()}')}CounterService计数器服务对象
     *
     * @type {${srfclassname('${appCounter.getCodeName()}')}CounterService}
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public ${srfclassname('${appCounter.getCodeName()}')}counterservice: ${srfclassname('${appCounter.getCodeName()}')}CounterService = new ${srfclassname('${appCounter.getCodeName()}')}CounterService({ $store: this.$store });
</#if>

<#if view.isEnableQuickGroup()>

    /**
     * 代码表服务对象
     *
     * @type {CodeListService}
     * @memberof ${srfclassname('${view.name}')}Base
     */  
    public codeListService:CodeListService = new CodeListService({ $store: this.$store });

    /**
     * 快速分组数据对象
     *
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public qucikGroupData:any;

    /**
     * 快速分组是否有抛值
     *
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public isEmitQuickGroupValue:boolean = false;

    /**
     * 快速分组模型
     *
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public quickGroupModel:Array<any> = [];

    /**
     * 加载快速分组模型
     *
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public loadQuickGroupModel(){
        <#if view.getQuickGroupPSCodeList()??>
        <#assign codelist=view.getQuickGroupPSCodeList() />
        let quickGroupCodeList:any = {tag:'${codelist.codeName}',codelistType:'${codelist.getCodeListType()}'};
        if(quickGroupCodeList.tag && Object.is(quickGroupCodeList.codelistType,"STATIC")){
            const codelist = this.$store.getters.getCodeList(quickGroupCodeList.tag);
            if (codelist) {
                this.quickGroupModel = [...this.handleDynamicData(JSON.parse(JSON.stringify(codelist.items)))];
            } else {
                <#noparse>console.log(`----${quickGroupCodeList.tag}----代码表不存在`);</#noparse>
            }
        }else if(quickGroupCodeList.tag && Object.is(quickGroupCodeList.codelistType,"DYNAMIC")){
            this.codeListService.getItems(quickGroupCodeList.tag,{},{}).then((res:any) => {
                this.quickGroupModel = res;
            }).catch((error:any) => {
                <#noparse>console.log(`----${quickGroupCodeList.tag}----代码表不存在`);</#noparse>
            });
        }
        </#if>
    }

    /**
     * 处理快速分组模型动态数据部分(%xxx%)
     *
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public handleDynamicData(inputArray:Array<any>){
        if(inputArray.length >0){
            inputArray.forEach((item:any) =>{
               if(item.data && Object.keys(item.data).length >0){
                   Object.keys(item.data).forEach((name:any) =>{
                        let value: any = item.data[name];
                        if (value && typeof(value)=='string' && value.startsWith('%') && value.endsWith('%')) {
                            const key = (value.substring(1, value.length - 1)).toLowerCase();
                            if (this.context[key]) {
                                value = this.context[key];
                            } else if(this.viewparams[key]){
                                value = this.viewparams[key];
                            }
                        }
                        item.data[name] = value;
                   })
               }
            })
        }
        return inputArray;
    }

    /**
     * 快速分组值变化
     *
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public qucikGroupValueChange($event:any){
        if($event && $event.data){
            this.qucikGroupData = $event.data;
            if(this.isEmitQuickGroupValue){
                this.onSearch($event);
            }
        }
        this.isEmitQuickGroupValue = true;
    }
</#if>
<#if view.getQuickPSDESearchForm()??>

    /**
     * 快速搜索栏数据对象
     *
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public qucikFormData:any;

    /**
     * 快速搜索栏值变化
     *
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public qucikFormValueChange($event:any){
        this.qucikFormData = $event;
        this.onSearch($event);
    }
</#if>

<#ibizinclude>
./VIEW_BOTTOM-BASE.vue.ftl
</#ibizinclude>

<#ibizinclude>
./VIEW-BASE.style.ftl
</#ibizinclude>