<#assign import_block>
<#list ctrl.getPSDEFormItems() as deItem>
<#if deItem.getPSEditor()?? && deItem.getPSEditor().getPSAppDataEntity?? && deItem.getPSEditor().getPSAppDataEntity()??>
<#assign _appde = deItem.getPSEditor().getPSAppDataEntity()/>
<#if _appde.getId() != appde.getId()>
<#if !P.exists("importService", _appde.getId(), "")>
import ${srfclassname('${_appde.getCodeName()}')}Service from '@/service/${srffilepath2(_appde.getCodeName())}/${srffilepath2(_appde.getCodeName())}-service';
</#if>
</#if>
</#if>
</#list>
</#assign>
<#ibizinclude>
./SERVICE_HEADER.ts.ftl
</#ibizinclude>
    <#list ctrl.getPSDEFormItems() as deItem>
    <#if deItem.getPSEditor()?? && deItem.getPSEditor().getPSAppDataEntity?? && deItem.getPSEditor().getPSAppDataEntity()??>
    <#assign _appde = deItem.getPSEditor().getPSAppDataEntity()/>
    <#if _appde.getId() != appde.getId()>
    <#if !P.exists("importService2", _appde.getId(), "")>

    /**
     * ${_appde.getLogicName()}服务对象
     *
     * @type {${srfclassname('${_appde.getCodeName()}')}Service}
     * @memberof ${srfclassname('${ctrl.codeName}')}Service
     */
    public ${_appde.getCodeName()?lower_case}Service: ${srfclassname('${_appde.getCodeName()}')}Service = new ${srfclassname('${_appde.getCodeName()}')}Service();
    </#if>
    </#if>
    </#if>
    </#list>

    /**
     * 处理数据
     *
     * @private
     * @param {Promise<any>} promise
     * @returns {Promise<any>}
     * @memberof ${srfclassname('${ctrl.codeName}')}Service
     */
    private doItems(promise: Promise<any>, deKeyField: string, deName: string): Promise<any> {
        return new Promise((resolve, reject) => {
            promise.then((response: any) => {
                if (response && response.status === 200) {
                    const data = response.data;
                    data.forEach((item:any,index:number) =>{
                        item[deName] = item[deKeyField];
                        data[index] = item;
                    });
                    resolve(data);
                } else {
                    reject([])
                }
            }).catch((response: any) => {
                reject([])
            });
        });
    }

    /**
     * 获取跨实体数据集合
     *
     * @param {string} serviceName 服务名称
     * @param {string} interfaceName 接口名称
     * @param {*} data
     * @param {boolean} [isloading]
     * @returns {Promise<any[]>}
     * @memberof  ${srfclassname('${ctrl.codeName}')}Service
     */
    @Errorlog
    public getItems(serviceName: string, interfaceName: string, context: any = {}, data: any, isloading?: boolean): Promise<any[]> {
        data.page = data.page ? data.page : 0;
        data.size = data.size ? data.size : 1000;
    <#list ctrl.getPSDEFormItems() as deItem>
    <#if deItem.getPSEditor()?? && deItem.getPSEditor().getPSAppDataEntity?? && deItem.getPSEditor().getPSAppDataEntity()?? && deItem.getPSEditor().getPSAppDEDataSet?? && deItem.getPSEditor().getPSAppDEDataSet()??>
    <#assign _appde = deItem.getPSEditor().getPSAppDataEntity()/>
    <#assign deDataSet = deItem.getPSEditor().getPSAppDEDataSet()/>
    <#if !P.exists("importService4", _appde.getId() + deDataSet.getCodeName(), "")>
    <#if _appde.getId() == appde.getId()>
        if (Object.is(serviceName, '${srfclassname('${_appde.getCodeName()}')}Service') && Object.is(interfaceName, '${deDataSet.getCodeName()}')) {
            return this.doItems(this.appEntityService.${deDataSet.getCodeName()}(JSON.parse(JSON.stringify(context)), data, isloading), '${_appde.getKeyPSAppDEField().getCodeName()?lower_case}', '${_appde.getCodeName()?lower_case}');
        }
    <#else>
        if (Object.is(serviceName, '${srfclassname('${_appde.getCodeName()}')}Service') && Object.is(interfaceName, '${deDataSet.getCodeName()}')) {
            return this.doItems(this.${_appde.getCodeName()?lower_case}Service.${deDataSet.getCodeName()}(JSON.parse(JSON.stringify(context)),data, isloading), '${_appde.getKeyPSAppDEField().getCodeName()?lower_case}', '${_appde.getCodeName()?lower_case}');
        }
    </#if>
    </#if>
    </#if>
    </#list>

        return Promise.reject([])
    }

    /**
     * 启动工作流
     *
     * @param {string} action
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @param {*} [localdata]
     * @returns {Promise<any>}
     * @memberof ${srfclassname('${ctrl.codeName}')}Service
     */
    @Errorlog
    public wfstart(action: string,context: any = {},data: any = {}, isloading?: boolean,localdata?:any): Promise<any> {
        data = this.handleWFData(data);
        context = this.handleRequestData(action,context,data).context;
        return new Promise((resolve: any, reject: any) => {
            let result: Promise<any>;
            const _appEntityService: any = this.appEntityService;
            if (_appEntityService[action] && _appEntityService[action] instanceof Function) {
                result = _appEntityService[action](context,data, isloading,localdata);
            } else {
                result = this.appEntityService.WFStart(context,data, isloading,localdata);
            }
            result.then((response) => {
                this.handleResponse(action, response);
                resolve(response);
            }).catch(response => {
                reject(response);
            });
        });
    }

    /**
     * 提交工作流
     *
     * @param {string} action
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @param {*} [localdata]
     * @returns {Promise<any>}
     * @memberof ${srfclassname('${ctrl.codeName}')}Service
     */
    @Errorlog
    public wfsubmit(action: string,context: any = {}, data: any = {}, isloading?: boolean,localdata?:any): Promise<any> {
        data = this.handleWFData(data,true);
        context = this.handleRequestData(action,context,data,true).context;
        return new Promise((resolve: any, reject: any) => {
            let result: Promise<any>;
            const _appEntityService: any = this.appEntityService;
            if (_appEntityService[action] && _appEntityService[action] instanceof Function) {
                result = _appEntityService[action](context,data, isloading,localdata);
            } else {
                result = this.appEntityService.WFSubmit(context,data, isloading,localdata);
            }
            result.then((response) => {
                this.handleResponse(action, response);
                resolve(response);
            }).catch(response => {
                reject(response);
            });
        });
    }

    /**
     * 添加数据
     *
     * @param {string} action
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof ${srfclassname('${ctrl.codeName}')}Service
     */
    @Errorlog
    public add(action: string, context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        const {data:Data,context:Context} = this.handleRequestData(action,context,data);
        <#-- 手动修改数据主键的情况start -->
        <#list ctrl.getPSDEFormItems() as formitem>
        <#if formitem.getPSAppDEField?? && formitem.getPSAppDEField()??>
        <#if !formitem.isHidden() && formitem.getPSAppDEField().isKeyField()>
        Object.assign(Data,{${appde.getKeyPSAppDEField().getCodeName()?lower_case}: data.${formitem.getName()}, srffrontuf: '1'});
        </#if>
        </#if>
        </#list>
        <#-- 手动修改数据主键的情况end -->
        return new Promise((resolve: any, reject: any) => {
            let result: Promise<any>;
            const _appEntityService: any = this.appEntityService;
            if (_appEntityService[action] && _appEntityService[action] instanceof Function) {
                result = _appEntityService[action](Context,Data, isloading);
            } else {
                result = this.appEntityService.Create(Context,Data, isloading);
            }
            result.then((response) => {
                this.handleResponse(action, response);
                resolve(response);
            }).catch(response => {
                reject(response);
            });
        });
    }

    /**
     * 删除数据
     *
     * @param {string} action
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof ${srfclassname('${ctrl.codeName}')}Service
     */
    @Errorlog
    public delete(action: string, context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        const {data:Data,context:Context} = this.handleRequestData(action,context,data);
        return new Promise((resolve: any, reject: any) => {
            let result: Promise<any>;
            const _appEntityService: any = this.appEntityService;
            if (_appEntityService[action] && _appEntityService[action] instanceof Function) {
                result = _appEntityService[action](Context,Data, isloading);
            } else {
                result = this.appEntityService.Remove(Context,Data, isloading);
            }
            result.then((response) => {
                resolve(response);
            }).catch(response => {
                reject(response);
            });
        });
    }

    /**
     * 修改数据
     *
     * @param {string} action
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof ${srfclassname('${ctrl.codeName}')}Service
     */
    @Errorlog
    public update(action: string, context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        const {data:Data,context:Context} = this.handleRequestData(action,context,data);
        return new Promise((resolve: any, reject: any) => {
            let result: Promise<any>;
            const _appEntityService: any = this.appEntityService;
            if (_appEntityService[action] && _appEntityService[action] instanceof Function) {
                result = _appEntityService[action](Context,Data, isloading);
            } else {
                result = this.appEntityService.Update(Context,Data, isloading);
            }
            result.then((response) => {
                this.handleResponse(action, response);
                resolve(response);
            }).catch(response => {
                reject(response);
            });
        });
    }

    /**
     * 查询数据
     *
     * @param {string} action
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof ${srfclassname('${ctrl.codeName}')}Service
     */
    @Errorlog
    public get(action: string,context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        const {data:Data,context:Context} = this.handleRequestData(action,context,data);
        return new Promise((resolve: any, reject: any) => {
            let result: Promise<any>;
            const _appEntityService: any = this.appEntityService;
            if (_appEntityService[action] && _appEntityService[action] instanceof Function) {
                result = _appEntityService[action](Context,Data, isloading);
            } else {
                result = this.appEntityService.Get(Context,Data, isloading);
            }
            result.then((response) => {
                this.handleResponse(action, response);
                resolve(response);
            }).catch(response => {
                reject(response);
            });
        });
    }

    /**
     * 加载草稿
     *
     * @param {string} action
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof ${srfclassname('${ctrl.codeName}')}Service
     */
    @Errorlog
    public loadDraft(action: string,context: any = {}, data: any = {}, isloading?: boolean): Promise<any> {
        const {data:Data,context:Context} = this.handleRequestData(action,context,data);
<#if ctrl.getControlType() != 'SEARCHFORM'>
        //仿真主键数据
        const PrimaryKey = Util.createUUID();
        Data.${appde.getKeyPSAppDEField().getCodeName()?lower_case} = PrimaryKey;
        Data.${appde.getCodeName()?lower_case} = PrimaryKey;
</#if>
        return new Promise((resolve: any, reject: any) => {
            let result: Promise<any>;
            const _appEntityService: any = this.appEntityService;
            if (_appEntityService[action] && _appEntityService[action] instanceof Function) {
                result = _appEntityService[action](Context,Data, isloading);
            } else {
                result = this.appEntityService.GetDraft(Context,Data, isloading);
            }
            result.then((response) => {
<#if ctrl.getControlType() != 'SEARCHFORM'>
                response.data.${appde.getKeyPSAppDEField().getCodeName()?lower_case} = PrimaryKey;
</#if>
                this.handleResponse(action, response, true);
                resolve(response);
            }).catch(response => {
                reject(response);
            });
        });
    }

     /**
     * 前台逻辑
     * @param {string} action
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof ${srfclassname('${ctrl.codeName}')}Service
     */
    @Errorlog
    public frontLogic(action:string,context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        const {data:Data,context:Context} = this.handleRequestData(action,context,data);
        return new Promise((resolve: any, reject: any)=>{
            let result: Promise<any>;
            const _appEntityService: any = this.appEntityService;
            if (_appEntityService[action] && _appEntityService[action] instanceof Function) {
                result = _appEntityService[action](Context,Data, isloading);
            } else {
                return Promise.reject({ status: 500, data: { title: '失败', message: '系统异常' } });
            }
            result.then((response) => {
                this.handleResponse(action, response,true);
                resolve(response);
            }).catch(response => {
                reject(response);
            });
        })
    }

    /**
     * 处理请求数据
     * 
     * @param action 行为 
     * @param data 数据
     * @memberof ${srfclassname('${ctrl.codeName}')}Service
     */
    public handleRequestData(action: string,context:any, data: any = {},isMerge:boolean = false){
        let mode: any = this.getMode();
        if (!mode && mode.getDataItems instanceof Function) {
            return data;
        }
        let formItemItems: any[] = mode.getDataItems();
        let requestData:any = {};
        if(isMerge && (data && data.viewparams)){
            Object.assign(requestData,data.viewparams);
        }
        formItemItems.forEach((item:any) =>{
            if(item && item.dataType && Object.is(item.dataType,'FONTKEY')){
                if(item && item.prop){
                    requestData[item.prop] = context[item.name];
                }
            }else{
                if(item && item.prop){
                    requestData[item.prop] = data[item.name];
                }
            }
        });
        let tempContext:any = JSON.parse(JSON.stringify(context));
        if(tempContext && tempContext.srfsessionid){
            tempContext.srfsessionkey = tempContext.srfsessionid;
            delete tempContext.srfsessionid;
        }
        return {context:tempContext,data:requestData};
    }

    /**
     * 通过属性名称获取表单项名称
     * 
     * @param name 实体属性名称 
     * @memberof ${srfclassname('${ctrl.codeName}')}Service
     */
    public getItemNameByDeName(name:string) :string{
        let itemName = name;
        let mode: any = this.getMode();
        if (!mode && mode.getDataItems instanceof Function) {
            return name;
        }
        let formItemItems: any[] = mode.getDataItems();
        formItemItems.forEach((item:any)=>{
            if(item.prop === name){
                itemName = item.name;
            }
        });
        return itemName.trim();
    }

<#ibizinclude>
./SERVICE_BOTTOM.ts.ftl
</#ibizinclude>