import { Subject } from 'rxjs';
import { TreeExpViewBase } from '@/studio-core';
import HROMHierarchyService from '@/service/hromhierarchy/hromhierarchy-service';
import HROMHierarchyAuthService from '@/authservice/hromhierarchy/hromhierarchy-auth-service';
import TreeExpViewEngine from '@engine/view/tree-exp-view-engine';
import HROMHierarchyUIService from '@/uiservice/hromhierarchy/hromhierarchy-ui-service';

/**
 * 组织层次结构树导航视图视图基类
 *
 * @export
 * @class HROMHierarchyTreeExpViewBase
 * @extends {TreeExpViewBase}
 */
export class HROMHierarchyTreeExpViewBase extends TreeExpViewBase {
    /**
     * 视图对应应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof HROMHierarchyTreeExpViewBase
     */
    protected appDeName: string = 'hromhierarchy';

    /**
     * 应用实体主键
     *
     * @protected
     * @type {string}
     * @memberof HROMHierarchyTreeExpViewBase
     */
    protected appDeKey: string = 'omhierarchyid';

    /**
     * 应用实体主信息
     *
     * @protected
     * @type {string}
     * @memberof HROMHierarchyTreeExpViewBase
     */
    protected appDeMajor: string = 'organizationname';

    /**
     * 实体服务对象
     *
     * @type {HROMHierarchyService}
     * @memberof HROMHierarchyTreeExpViewBase
     */
    protected appEntityService: HROMHierarchyService = new HROMHierarchyService;

    /**
     * 实体权限服务对象
     *
     * @type HROMHierarchyUIService
     * @memberof HROMHierarchyTreeExpViewBase
     */
    public appUIService: HROMHierarchyUIService = new HROMHierarchyUIService(this.$store);


    /**
     * 计数器服务对象集合
     *
     * @protected
     * @type {Array<*>}
     * @memberof HROMHierarchyTreeExpViewBase
     */    
    protected counterServiceArray: Array<any> = [];

    /**
     * 视图模型数据
     *
     * @protected
     * @type {*}
     * @memberof HROMHierarchyTreeExpViewBase
     */
    protected model: any = {
        srfCaption: 'entities.hromhierarchy.views.treeexpview.caption',
        srfTitle: 'entities.hromhierarchy.views.treeexpview.title',
        srfSubTitle: 'entities.hromhierarchy.views.treeexpview.subtitle',
        dataInfo: ''
    }

    /**
     * 容器模型
     *
     * @protected
     * @type {*}
     * @memberof HROMHierarchyTreeExpViewBase
     */
    protected containerModel: any = {
        view_treeexpbar: { name: 'treeexpbar', type: 'TREEEXPBAR' },
    };


	/**
     * 视图唯一标识
     *
     * @protected
     * @type {string}
     * @memberof ViewBase
     */
	protected viewtag: string = 'bf1effbdf9fb9d7d2a1c9d281ab35441';


    /**
     * 视图引擎
     *
     * @public
     * @type {Engine}
     * @memberof HROMHierarchyTreeExpViewBase
     */
    public engine: TreeExpViewEngine = new TreeExpViewEngine();

    /**
     * 引擎初始化
     *
     * @public
     * @memberof HROMHierarchyTreeExpViewBase
     */
    public engineInit(): void {
        this.engine.init({
            view: this,
            treeexpbar: this.$refs.treeexpbar,
            keyPSDEField: 'hromhierarchy',
            majorPSDEField: 'organizationname',
            isLoadDefault: true,
        });
    }

    /**
     * treeexpbar 部件 selectionchange 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof HROMHierarchyTreeExpViewBase
     */
    public treeexpbar_selectionchange($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('treeexpbar', 'selectionchange', $event);
    }

    /**
     * treeexpbar 部件 activated 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof HROMHierarchyTreeExpViewBase
     */
    public treeexpbar_activated($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('treeexpbar', 'activated', $event);
    }

    /**
     * treeexpbar 部件 load 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof HROMHierarchyTreeExpViewBase
     */
    public treeexpbar_load($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('treeexpbar', 'load', $event);
    }

    /**
     * 打开新建数据视图
     *
     * @param {any[]} args
     * @param {*} [params]
     * @param {*} [fullargs]
     * @param {*} [$event]
     * @param {*} [xData]
     * @memberof HROMHierarchyTreeExpView
     */
    public newdata(args: any[],fullargs?:any[], params?: any, $event?: any, xData?: any) {
        let localContext:any = null;
        let localViewParam:any =null;
    this.$Notice.warning({ title: '错误', desc: '未指定关系视图' });
    }


    /**
     * 打开编辑数据视图
     *
     * @param {any[]} args
     * @param {*} [params]
     * @param {*} [fullargs]
     * @param {*} [$event]
     * @param {*} [xData]
     * @memberof HROMHierarchyTreeExpView
     */
    public opendata(args: any[],fullargs?:any[],params?: any, $event?: any, xData?: any) {
    this.$Notice.warning({ title: '错误', desc: '未指定关系视图' });
    }



    /**
     * 视图唯一标识
     *
     * @type {string}
     * @memberof HROMHierarchyTreeExpView
     */
    public viewUID: string = 'base-hromhierarchy-tree-exp-view';


}