import { Subject } from 'rxjs';
import { TabExpViewBase } from '@/studio-core';
import HROMHierarchyCatService from '@/service/hromhierarchy-cat/hromhierarchy-cat-service';
import HROMHierarchyCatAuthService from '@/authservice/hromhierarchy-cat/hromhierarchy-cat-auth-service';
import TabExpViewEngine from '@engine/view/tab-exp-view-engine';
import HROMHierarchyCatUIService from '@/uiservice/hromhierarchy-cat/hromhierarchy-cat-ui-service';

/**
 * 结构层次类别分页编辑视图基类
 *
 * @export
 * @class HROMHierarchyCatTabExpViewBase
 * @extends {TabExpViewBase}
 */
export class HROMHierarchyCatTabExpViewBase extends TabExpViewBase {
    /**
     * 视图对应应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof HROMHierarchyCatTabExpViewBase
     */
    protected appDeName: string = 'hromhierarchycat';

    /**
     * 应用实体主键
     *
     * @protected
     * @type {string}
     * @memberof HROMHierarchyCatTabExpViewBase
     */
    protected appDeKey: string = 'omhierarchycatid';

    /**
     * 应用实体主信息
     *
     * @protected
     * @type {string}
     * @memberof HROMHierarchyCatTabExpViewBase
     */
    protected appDeMajor: string = 'omhierarchycatname';

    /**
     * 实体服务对象
     *
     * @type {HROMHierarchyCatService}
     * @memberof HROMHierarchyCatTabExpViewBase
     */
    protected appEntityService: HROMHierarchyCatService = new HROMHierarchyCatService;

    /**
     * 实体权限服务对象
     *
     * @type HROMHierarchyCatUIService
     * @memberof HROMHierarchyCatTabExpViewBase
     */
    public appUIService: HROMHierarchyCatUIService = new HROMHierarchyCatUIService(this.$store);


    /**
     * 计数器服务对象集合
     *
     * @protected
     * @type {Array<*>}
     * @memberof HROMHierarchyCatTabExpViewBase
     */    
    protected counterServiceArray: Array<any> = [];

    /**
     * 视图模型数据
     *
     * @protected
     * @type {*}
     * @memberof HROMHierarchyCatTabExpViewBase
     */
    protected model: any = {
        srfCaption: 'entities.hromhierarchycat.views.tabexpview.caption',
        srfTitle: 'entities.hromhierarchycat.views.tabexpview.title',
        srfSubTitle: 'entities.hromhierarchycat.views.tabexpview.subtitle',
        dataInfo: ''
    }

    /**
     * 容器模型
     *
     * @protected
     * @type {*}
     * @memberof HROMHierarchyCatTabExpViewBase
     */
    protected containerModel: any = {
        view_toolbar: { name: 'toolbar', type: 'TOOLBAR' },
        view_tabexppanel: { name: 'tabexppanel', type: 'TABEXPPANEL' },
    };

    /**
     * 工具栏模型
     *
     * @type {*}
     * @memberof HROMHierarchyCatTabExpView
     */
    public toolBarModels: any = {
        tbitem1_ff_001: { name: 'tbitem1_ff_001', caption: '编辑', 'isShowCaption': true, 'isShowIcon': true, tooltip: '编辑', iconcls: 'fa fa-edit', icon: '', disabled: false, type: 'DEUIACTION', visabled: true,noprivdisplaymode:2,dataaccaction: '', uiaction: { tag: 'FF_001', target: 'SINGLEKEY', class: '' } },

        tbitem1_remove_sep: {  name: 'tbitem1_remove_sep', type: 'SEPERATOR', visabled: true, dataaccaction: '', uiaction: { } },
        tbitem1_remove: { name: 'tbitem1_remove', caption: '删除并关闭', 'isShowCaption': true, 'isShowIcon': true, tooltip: '删除并关闭', iconcls: 'fa fa-remove', icon: '', disabled: false, type: 'DEUIACTION', visabled: true,noprivdisplaymode:2,dataaccaction: '', uiaction: { tag: 'Remove', target: 'SINGLEKEY', class: '' } },

        tbitem2: {  name: 'tbitem2', type: 'SEPERATOR', visabled: true, dataaccaction: '', uiaction: { } },
        tbitem22: { name: 'tbitem22', caption: '关闭', 'isShowCaption': true, 'isShowIcon': true, tooltip: '关闭', iconcls: 'fa fa-sign-out', icon: '', disabled: false, type: 'DEUIACTION', visabled: true,noprivdisplaymode:2,dataaccaction: '', uiaction: { tag: 'Exit', target: '', class: '' } },

    };



	/**
     * 视图唯一标识
     *
     * @protected
     * @type {string}
     * @memberof ViewBase
     */
	protected viewtag: string = '1780a9ed77fb97f2cc3852cfdc55c32c';


    /**
     * 视图引擎
     *
     * @public
     * @type {Engine}
     * @memberof HROMHierarchyCatTabExpViewBase
     */
    public engine: TabExpViewEngine = new TabExpViewEngine();

    /**
     * 引擎初始化
     *
     * @public
     * @memberof HROMHierarchyCatTabExpViewBase
     */
    public engineInit(): void {
        this.engine.init({
            view: this,
            keyPSDEField: 'hromhierarchycat',
            majorPSDEField: 'omhierarchycatname',
            isLoadDefault: true,
        });
    }

    /**
     * toolbar 部件 click 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof HROMHierarchyCatTabExpViewBase
     */
    public toolbar_click($event: any, $event2?: any): void {
        if (Object.is($event.tag, 'tbitem1_ff_001')) {
            this.toolbar_tbitem1_ff_001_click(null, '', $event2);
        }
        if (Object.is($event.tag, 'tbitem1_remove')) {
            this.toolbar_tbitem1_remove_click(null, '', $event2);
        }
        if (Object.is($event.tag, 'tbitem22')) {
            this.toolbar_tbitem22_click(null, '', $event2);
        }
    }

    /**
     * 逻辑事件
     *
     * @param {*} [params={}]
     * @param {*} [tag]
     * @param {*} [$event]
     * @memberof 
     */
    public toolbar_tbitem1_ff_001_click(params: any = {}, tag?: any, $event?: any) {
        // 参数
        // 取数
        let datas: any[] = [];
        let xData: any = null;
        // _this 指向容器对象
        const _this: any = this;
        let paramJO:any = {};
        let contextJO:any = {};
        if (_this.getDatas && _this.getDatas instanceof Function) {
            datas = [..._this.getDatas()];
        }
        if(params){
          datas = [params];
        }
        // 界面行为
        const curUIService:HROMHierarchyCatUIService  = new HROMHierarchyCatUIService();
        curUIService.HROMHierarchyCat_FF_001(datas,contextJO, paramJO,  $event, xData,this,"HROMHierarchyCat");
    }

    /**
     * 逻辑事件
     *
     * @param {*} [params={}]
     * @param {*} [tag]
     * @param {*} [$event]
     * @memberof 
     */
    public toolbar_tbitem1_remove_click(params: any = {}, tag?: any, $event?: any) {
        // 参数
        // 取数
        let datas: any[] = [];
        let xData: any = null;
        // _this 指向容器对象
        const _this: any = this;
        let paramJO:any = {};
        let contextJO:any = {};
        if (_this.getDatas && _this.getDatas instanceof Function) {
            datas = [..._this.getDatas()];
        }
        if(params){
          datas = [params];
        }
        // 界面行为
        const curUIService:HROMHierarchyCatUIService  = new HROMHierarchyCatUIService();
        curUIService.HROMHierarchyCat_Remove(datas,contextJO, paramJO,  $event, xData,this,"HROMHierarchyCat");
    }

    /**
     * 逻辑事件
     *
     * @param {*} [params={}]
     * @param {*} [tag]
     * @param {*} [$event]
     * @memberof 
     */
    public toolbar_tbitem22_click(params: any = {}, tag?: any, $event?: any) {
        // 参数
        // 取数
        let datas: any[] = [];
        let xData: any = null;
        // _this 指向容器对象
        const _this: any = this;
        let paramJO:any = {};
        let contextJO:any = {};
        if (_this.getDatas && _this.getDatas instanceof Function) {
            datas = [..._this.getDatas()];
        }
        if(params){
          datas = [params];
        }
        // 界面行为
        this.Exit(datas, contextJO,paramJO,  $event, xData,this,"HROMHierarchyCat");
    }

    /**
     * 关闭
     *
     * @param {any[]} args 当前数据
     * @param {any} contextJO 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @memberof HROMHierarchyCatTabExpViewBase
     */
    public Exit(args: any[],contextJO?:any, params?: any, $event?: any, xData?: any,actionContext?:any,srfParentDeName?:string) {
        this.closeView(args);
        if(window.parent){
            window.parent.postMessage([{ ...args }],'*');
        }
    }


}