import { Subject } from 'rxjs';
import { EditViewBase } from '@/studio-core';
import HRPostService from '@/service/hrpost/hrpost-service';
import HRPostAuthService from '@/authservice/hrpost/hrpost-auth-service';
import EditViewEngine from '@engine/view/edit-view-engine';
import HRPostUIService from '@/uiservice/hrpost/hrpost-ui-service';

/**
 * 职位编辑视图视图基类
 *
 * @export
 * @class HRPostV_004Base
 * @extends {EditViewBase}
 */
export class HRPostV_004Base extends EditViewBase {
    /**
     * 视图对应应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof HRPostV_004Base
     */
    protected appDeName: string = 'hrpost';

    /**
     * 应用实体主键
     *
     * @protected
     * @type {string}
     * @memberof HRPostV_004Base
     */
    protected appDeKey: string = 'hrpostid';

    /**
     * 应用实体主信息
     *
     * @protected
     * @type {string}
     * @memberof HRPostV_004Base
     */
    protected appDeMajor: string = 'hrpostname';

    /**
     * 实体服务对象
     *
     * @type {HRPostService}
     * @memberof HRPostV_004Base
     */
    protected appEntityService: HRPostService = new HRPostService;

    /**
     * 实体权限服务对象
     *
     * @type HRPostUIService
     * @memberof HRPostV_004Base
     */
    public appUIService: HRPostUIService = new HRPostUIService(this.$store);


    /**
     * 计数器服务对象集合
     *
     * @protected
     * @type {Array<*>}
     * @memberof HRPostV_004Base
     */    
    protected counterServiceArray: Array<any> = [];

    /**
     * 视图模型数据
     *
     * @protected
     * @type {*}
     * @memberof HRPostV_004Base
     */
    protected model: any = {
        srfCaption: 'entities.hrpost.views.v_004.caption',
        srfTitle: 'entities.hrpost.views.v_004.title',
        srfSubTitle: 'entities.hrpost.views.v_004.subtitle',
        dataInfo: ''
    }

    /**
     * 容器模型
     *
     * @protected
     * @type {*}
     * @memberof HRPostV_004Base
     */
    protected containerModel: any = {
        view_form: { name: 'form', type: 'FORM' },
    };


	/**
     * 视图唯一标识
     *
     * @protected
     * @type {string}
     * @memberof ViewBase
     */
	protected viewtag: string = '5efdfaf722e7585dfd685922b16f7f88';


    /**
     * 视图引擎
     *
     * @public
     * @type {Engine}
     * @memberof HRPostV_004Base
     */
    public engine: EditViewEngine = new EditViewEngine();

    /**
     * 引擎初始化
     *
     * @public
     * @memberof HRPostV_004Base
     */
    public engineInit(): void {
        this.engine.init({
            view: this,
            form: this.$refs.form,
            p2k: '0',
            keyPSDEField: 'hrpost',
            majorPSDEField: 'hrpostname',
            isLoadDefault: true,
        });
    }

    /**
     * form 部件 save 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof HRPostV_004Base
     */
    public form_save($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('form', 'save', $event);
    }

    /**
     * form 部件 remove 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof HRPostV_004Base
     */
    public form_remove($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('form', 'remove', $event);
    }

    /**
     * form 部件 load 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof HRPostV_004Base
     */
    public form_load($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('form', 'load', $event);
    }


}