import AuthService from '../auth-service';

/**
 * 家庭情况权限服务对象基类
 *
 * @export
 * @class HRFamilyAuthServiceBase
 * @extends {AuthService}
 */
export default class HRFamilyAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  HRFamilyAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  HRFamilyAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof HRFamilyAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}