import AuthService from '../auth-service';

/**
 * 职务证书权限服务对象基类
 *
 * @export
 * @class HRDutyCertAuthServiceBase
 * @extends {AuthService}
 */
export default class HRDutyCertAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  HRDutyCertAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  HRDutyCertAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof HRDutyCertAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}