import { Subject } from 'rxjs';
import { TabExpViewBase } from '@/studio-core';
import HRPostService from '@/service/hrpost/hrpost-service';
import HRPostAuthService from '@/authservice/hrpost/hrpost-auth-service';
import TabExpViewEngine from '@engine/view/tab-exp-view-engine';
import HRPostUIService from '@/uiservice/hrpost/hrpost-ui-service';

/**
 * 职位信息视图基类
 *
 * @export
 * @class HRPostV_006Base
 * @extends {TabExpViewBase}
 */
export class HRPostV_006Base extends TabExpViewBase {
    /**
     * 视图对应应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof HRPostV_006Base
     */
    protected appDeName: string = 'hrpost';

    /**
     * 应用实体主键
     *
     * @protected
     * @type {string}
     * @memberof HRPostV_006Base
     */
    protected appDeKey: string = 'hrpostid';

    /**
     * 应用实体主信息
     *
     * @protected
     * @type {string}
     * @memberof HRPostV_006Base
     */
    protected appDeMajor: string = 'hrpostname';

    /**
     * 实体服务对象
     *
     * @type {HRPostService}
     * @memberof HRPostV_006Base
     */
    protected appEntityService: HRPostService = new HRPostService;

    /**
     * 实体权限服务对象
     *
     * @type HRPostUIService
     * @memberof HRPostV_006Base
     */
    public appUIService: HRPostUIService = new HRPostUIService(this.$store);


    /**
     * 计数器服务对象集合
     *
     * @protected
     * @type {Array<*>}
     * @memberof HRPostV_006Base
     */    
    protected counterServiceArray: Array<any> = [];

    /**
     * 视图模型数据
     *
     * @protected
     * @type {*}
     * @memberof HRPostV_006Base
     */
    protected model: any = {
        srfCaption: 'entities.hrpost.views.v_006.caption',
        srfTitle: 'entities.hrpost.views.v_006.title',
        srfSubTitle: 'entities.hrpost.views.v_006.subtitle',
        dataInfo: ''
    }

    /**
     * 容器模型
     *
     * @protected
     * @type {*}
     * @memberof HRPostV_006Base
     */
    protected containerModel: any = {
        view_toolbar: { name: 'toolbar', type: 'TOOLBAR' },
        view_tabexppanel: { name: 'tabexppanel', type: 'TABEXPPANEL' },
    };

    /**
     * 工具栏模型
     *
     * @type {*}
     * @memberof HRPostV_006
     */
    public toolBarModels: any = {
        tbitem1_ff_003: { name: 'tbitem1_ff_003', caption: '编辑', 'isShowCaption': true, 'isShowIcon': true, tooltip: '编辑', iconcls: 'fa fa-edit', icon: '', disabled: false, type: 'DEUIACTION', visabled: true,noprivdisplaymode:2,dataaccaction: '', uiaction: { tag: 'FF_003', target: 'SINGLEKEY', class: '' } },

        tbitem1_remove_sep: {  name: 'tbitem1_remove_sep', type: 'SEPERATOR', visabled: true, dataaccaction: '', uiaction: { } },
        tbitem1_remove: { name: 'tbitem1_remove', caption: '删除并关闭', 'isShowCaption': true, 'isShowIcon': true, tooltip: '删除并关闭', iconcls: 'fa fa-remove', icon: '', disabled: false, type: 'DEUIACTION', visabled: true,noprivdisplaymode:2,dataaccaction: '', uiaction: { tag: 'Remove', target: 'SINGLEKEY', class: '' } },

        tbitem2: {  name: 'tbitem2', type: 'SEPERATOR', visabled: true, dataaccaction: '', uiaction: { } },
        tbitem22: { name: 'tbitem22', caption: '关闭', 'isShowCaption': true, 'isShowIcon': true, tooltip: '关闭', iconcls: 'fa fa-sign-out', icon: '', disabled: false, type: 'DEUIACTION', visabled: true,noprivdisplaymode:2,dataaccaction: '', uiaction: { tag: 'Exit', target: '', class: '' } },

    };



	/**
     * 视图唯一标识
     *
     * @protected
     * @type {string}
     * @memberof ViewBase
     */
	protected viewtag: string = 'd2137112227c4243e95ffe9ef7eaafab';


    /**
     * 视图引擎
     *
     * @public
     * @type {Engine}
     * @memberof HRPostV_006Base
     */
    public engine: TabExpViewEngine = new TabExpViewEngine();

    /**
     * 引擎初始化
     *
     * @public
     * @memberof HRPostV_006Base
     */
    public engineInit(): void {
        this.engine.init({
            view: this,
            keyPSDEField: 'hrpost',
            majorPSDEField: 'hrpostname',
            isLoadDefault: true,
        });
    }

    /**
     * toolbar 部件 click 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof HRPostV_006Base
     */
    public toolbar_click($event: any, $event2?: any): void {
        if (Object.is($event.tag, 'tbitem1_ff_003')) {
            this.toolbar_tbitem1_ff_003_click(null, '', $event2);
        }
        if (Object.is($event.tag, 'tbitem1_remove')) {
            this.toolbar_tbitem1_remove_click(null, '', $event2);
        }
        if (Object.is($event.tag, 'tbitem22')) {
            this.toolbar_tbitem22_click(null, '', $event2);
        }
    }

    /**
     * 逻辑事件
     *
     * @param {*} [params={}]
     * @param {*} [tag]
     * @param {*} [$event]
     * @memberof 
     */
    public toolbar_tbitem1_ff_003_click(params: any = {}, tag?: any, $event?: any) {
        // 参数
        // 取数
        let datas: any[] = [];
        let xData: any = null;
        // _this 指向容器对象
        const _this: any = this;
        let paramJO:any = {};
        let contextJO:any = {};
        if (_this.getDatas && _this.getDatas instanceof Function) {
            datas = [..._this.getDatas()];
        }
        if(params){
          datas = [params];
        }
        // 界面行为
        const curUIService:HRPostUIService  = new HRPostUIService();
        curUIService.HRPost_FF_003(datas,contextJO, paramJO,  $event, xData,this,"HRPost");
    }

    /**
     * 逻辑事件
     *
     * @param {*} [params={}]
     * @param {*} [tag]
     * @param {*} [$event]
     * @memberof 
     */
    public toolbar_tbitem1_remove_click(params: any = {}, tag?: any, $event?: any) {
        // 参数
        // 取数
        let datas: any[] = [];
        let xData: any = null;
        // _this 指向容器对象
        const _this: any = this;
        let paramJO:any = {};
        let contextJO:any = {};
        if (_this.getDatas && _this.getDatas instanceof Function) {
            datas = [..._this.getDatas()];
        }
        if(params){
          datas = [params];
        }
        // 界面行为
        const curUIService:HRPostUIService  = new HRPostUIService();
        curUIService.HRPost_Remove(datas,contextJO, paramJO,  $event, xData,this,"HRPost");
    }

    /**
     * 逻辑事件
     *
     * @param {*} [params={}]
     * @param {*} [tag]
     * @param {*} [$event]
     * @memberof 
     */
    public toolbar_tbitem22_click(params: any = {}, tag?: any, $event?: any) {
        // 参数
        // 取数
        let datas: any[] = [];
        let xData: any = null;
        // _this 指向容器对象
        const _this: any = this;
        let paramJO:any = {};
        let contextJO:any = {};
        if (_this.getDatas && _this.getDatas instanceof Function) {
            datas = [..._this.getDatas()];
        }
        if(params){
          datas = [params];
        }
        // 界面行为
        this.Exit(datas, contextJO,paramJO,  $event, xData,this,"HRPost");
    }

    /**
     * 关闭
     *
     * @param {any[]} args 当前数据
     * @param {any} contextJO 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @memberof HRPostV_006Base
     */
    public Exit(args: any[],contextJO?:any, params?: any, $event?: any, xData?: any,actionContext?:any,srfParentDeName?:string) {
        this.closeView(args);
        if(window.parent){
            window.parent.postMessage([{ ...args }],'*');
        }
    }


}