import { Subject } from 'rxjs';
import { OptionViewBase } from '@/studio-core';
import HRPostService from '@/service/hrpost/hrpost-service';
import HRPostAuthService from '@/authservice/hrpost/hrpost-auth-service';
import OptionViewEngine from '@engine/view/option-view-engine';
import HRPostUIService from '@/uiservice/hrpost/hrpost-ui-service';

/**
 * 职位快速新建视图基类
 *
 * @export
 * @class HRPostV_005Base
 * @extends {OptionViewBase}
 */
export class HRPostV_005Base extends OptionViewBase {
    /**
     * 视图对应应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof HRPostV_005Base
     */
    protected appDeName: string = 'hrpost';

    /**
     * 应用实体主键
     *
     * @protected
     * @type {string}
     * @memberof HRPostV_005Base
     */
    protected appDeKey: string = 'hrpostid';

    /**
     * 应用实体主信息
     *
     * @protected
     * @type {string}
     * @memberof HRPostV_005Base
     */
    protected appDeMajor: string = 'hrpostname';

    /**
     * 实体服务对象
     *
     * @type {HRPostService}
     * @memberof HRPostV_005Base
     */
    protected appEntityService: HRPostService = new HRPostService;

    /**
     * 实体权限服务对象
     *
     * @type HRPostUIService
     * @memberof HRPostV_005Base
     */
    public appUIService: HRPostUIService = new HRPostUIService(this.$store);


    /**
     * 计数器服务对象集合
     *
     * @protected
     * @type {Array<*>}
     * @memberof HRPostV_005Base
     */    
    protected counterServiceArray: Array<any> = [];

    /**
     * 视图模型数据
     *
     * @protected
     * @type {*}
     * @memberof HRPostV_005Base
     */
    protected model: any = {
        srfCaption: 'entities.hrpost.views.v_005.caption',
        srfTitle: 'entities.hrpost.views.v_005.title',
        srfSubTitle: 'entities.hrpost.views.v_005.subtitle',
        dataInfo: ''
    }

    /**
     * 容器模型
     *
     * @protected
     * @type {*}
     * @memberof HRPostV_005Base
     */
    protected containerModel: any = {
        view_form: { name: 'form', type: 'FORM' },
        view_okbtn: { name: 'okbtn', type: 'button', text: '确定', disabled: true },
        view_cancelbtn: { name: 'cancelbtn', type: 'button', text: '取消', disabled: false },
        view_leftbtn: { name: 'leftbtn', type: 'button', text: '左移', disabled: true },
        view_rightbtn: { name: 'rightbtn', type: 'button', text: '右移', disabled: true },
        view_allleftbtn: { name: 'allleftbtn', type: 'button', text: '全部左移', disabled: true },
        view_allrightbtn: { name: 'allrightbtn', type: 'button', text: '全部右移', disabled: true },
    };


	/**
     * 视图唯一标识
     *
     * @protected
     * @type {string}
     * @memberof ViewBase
     */
	protected viewtag: string = 'c1a754fe9d4ff67c56d0bb4b6ae949be';


    /**
     * 视图引擎
     *
     * @public
     * @type {Engine}
     * @memberof HRPostV_005Base
     */
    public engine: OptionViewEngine = new OptionViewEngine();

    /**
     * 引擎初始化
     *
     * @public
     * @memberof HRPostV_005Base
     */
    public engineInit(): void {
        this.engine.init({
            view: this,
            form: this.$refs.form,
            p2k: '0',
            keyPSDEField: 'hrpost',
            majorPSDEField: 'hrpostname',
            isLoadDefault: true,
        });
    }

    /**
     * form 部件 save 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof HRPostV_005Base
     */
    public form_save($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('form', 'save', $event);
    }

    /**
     * form 部件 remove 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof HRPostV_005Base
     */
    public form_remove($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('form', 'remove', $event);
    }

    /**
     * form 部件 load 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof HRPostV_005Base
     */
    public form_load($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('form', 'load', $event);
    }


}