import AuthService from '../auth-service';

/**
 * 论文信息权限服务对象基类
 *
 * @export
 * @class HRPaperAuthServiceBase
 * @extends {AuthService}
 */
export default class HRPaperAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  HRPaperAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  HRPaperAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof HRPaperAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}