import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, GridControlBase } from '@/studio-core';
import HROrganizationService from '@/service/hrorganization/hrorganization-service';
import MainService from './main-grid-service';
import HROrganizationUIService from '@/uiservice/hrorganization/hrorganization-ui-service';
import { FormItemModel } from '@/model/form-detail';


/**
 * grid部件基类
 *
 * @export
 * @class GridControlBase
 * @extends {MainGridBase}
 */
export class MainGridBase extends GridControlBase {

    /**
     * 获取部件类型
     *
     * @protected
     * @type {string}
     * @memberof MainGridBase
     */
    protected controlType: string = 'GRID';

    /**
     * 建构部件服务对象
     *
     * @type {MainService}
     * @memberof MainGridBase
     */
    public service: MainService = new MainService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {HROrganizationService}
     * @memberof MainGridBase
     */
    public appEntityService: HROrganizationService = new HROrganizationService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof MainGridBase
     */
    protected appDeName: string = 'hrorganization';

    /**
     * 界面UI服务对象
     *
     * @type {HROrganizationUIService}
     * @memberof MainBase
     */  
    public appUIService:HROrganizationUIService = new HROrganizationUIService(this.$store);

    /**
     * 界面行为模型
     *
     * @type {*}
     * @memberof MainBase
     */  
    public ActionModel: any = {
    };

    /**
     * 本地缓存标识
     *
     * @protected
     * @type {string}
     * @memberof MainBase
     */
    protected localStorageTag: string = 'hrorganization_main_grid';

    /**
     * 所有列成员
     *
     * @type {any[]}
     * @memberof MainGridBase
     */
    public allColumns: any[] = [
        {
            name: 'orgcode',
            label: '组织编码',
            langtag: 'entities.hrorganization.main_grid.columns.orgcode',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'organizationname',
            label: '组织名称',
            langtag: 'entities.hrorganization.main_grid.columns.organizationname',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'organizationtype',
            label: '组织类型',
            langtag: 'entities.hrorganization.main_grid.columns.organizationtype',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'shortname',
            label: '组织简称',
            langtag: 'entities.hrorganization.main_grid.columns.shortname',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'operationunittype',
            label: '运营单位类型',
            langtag: 'entities.hrorganization.main_grid.columns.operationunittype',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'showorder',
            label: '排序号',
            langtag: 'entities.hrorganization.main_grid.columns.showorder',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
    ]

    /**
     * 获取表格行模型
     *
     * @type {*}
     * @memberof MainGridBase
     */
    public getGridRowModel(){
        return {
          srfkey: new FormItemModel(),
        }
    }

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof MainGridBase
     */
    public rules: any = {
        srfkey: [
            { required: false, validator: (rule:any, value:any, callback:any) => { return (rule.required && (value === null || value === undefined || value === "")) ? false : true;}, message: '组织 值不能为空', trigger: 'change' },
            { required: false, validator: (rule:any, value:any, callback:any) => { return (rule.required && (value === null || value === undefined || value === "")) ? false : true;}, message: '组织 值不能为空', trigger: 'blur' },
        ],
    }

    /**
     * 获取对应列class
     *
     * @type {*}
     * @memberof MainBase
     */
    public hasRowEdit: any = {
        'orgcode':false,
        'organizationname':false,
        'organizationtype':false,
        'shortname':false,
        'operationunittype':false,
        'showorder':false,
    };

    /**
     * 获取对应列class
     *
     * @param {*} $args row 行数据，column 列数据，rowIndex 行索引，列索引
     * @returns {void}
     * @memberof MainBase
     */
    public getCellClassName(args: {row: any, column: any, rowIndex: number, columnIndex: number}): any {
        return ( this.hasRowEdit[args.column.property] && this.actualIsOpenEdit ) ? "edit-cell" : "info-cell";
    }


    /**
     * 导出数据格式化
     *
     * @param {*} filterVal
     * @param {*} jsonData
     * @param {any[]} [codelistColumns=[]]
     * @returns {Promise<any>}
     * @memberof MainGridBase
     */
    public async formatExcelData(filterVal: any, jsonData: any, codelistColumns?: any[]): Promise<any> {
        return super.formatExcelData(filterVal, jsonData, [
            {
                name: 'organizationtype',
                srfkey: 'OrganizationType',
                codelistType : 'STATIC',
                renderMode: 'other',
                textSeparator: '、',
                valueSeparator: ',',
            },
            {
                name: 'operationunittype',
                srfkey: 'CL_HR_0001',
                codelistType : 'STATIC',
                renderMode: 'other',
                textSeparator: '、',
                valueSeparator: ',',
            },
        ]);
    }

}