import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, GridControlBase } from '@/studio-core';
import HRArchivesMoveService from '@/service/hrarchives-move/hrarchives-move-service';
import MainService from './main-grid-service';
import HRArchivesMoveUIService from '@/uiservice/hrarchives-move/hrarchives-move-ui-service';
import { FormItemModel } from '@/model/form-detail';


/**
 * grid部件基类
 *
 * @export
 * @class GridControlBase
 * @extends {MainGridBase}
 */
export class MainGridBase extends GridControlBase {

    /**
     * 获取部件类型
     *
     * @protected
     * @type {string}
     * @memberof MainGridBase
     */
    protected controlType: string = 'GRID';

    /**
     * 建构部件服务对象
     *
     * @type {MainService}
     * @memberof MainGridBase
     */
    public service: MainService = new MainService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {HRArchivesMoveService}
     * @memberof MainGridBase
     */
    public appEntityService: HRArchivesMoveService = new HRArchivesMoveService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof MainGridBase
     */
    protected appDeName: string = 'hrarchivesmove';

    /**
     * 应用实体中文名称
     *
     * @protected
     * @type {string}
     * @memberof MainGridBase
     */
    protected appDeLogicName: string = '档案调档';

    /**
     * 界面UI服务对象
     *
     * @type {HRArchivesMoveUIService}
     * @memberof MainBase
     */  
    public appUIService:HRArchivesMoveUIService = new HRArchivesMoveUIService(this.$store);

    /**
     * 界面行为模型
     *
     * @type {*}
     * @memberof MainBase
     */  
    public ActionModel: any = {
    };

    /**
     * 本地缓存标识
     *
     * @protected
     * @type {string}
     * @memberof MainBase
     */
    protected localStorageTag: string = 'hrarchivesmove_main_grid';

    /**
     * 是否支持分页
     *
     * @type {boolean}
     * @memberof MainGridBase
     */
    public isEnablePagingBar: boolean = false;

    /**
     * 所有列成员
     *
     * @type {any[]}
     * @memberof MainGridBase
     */
    public allColumns: any[] = [
        {
            name: 'movetype',
            label: '调档类型',
            langtag: 'entities.hrarchivesmove.main_grid.columns.movetype',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'moveoutorg',
            label: '调出单位',
            langtag: 'entities.hrarchivesmove.main_grid.columns.moveoutorg',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'moveinorg',
            label: '调入单位',
            langtag: 'entities.hrarchivesmove.main_grid.columns.moveinorg',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'activetime',
            label: '调档时间',
            langtag: 'entities.hrarchivesmove.main_grid.columns.activetime',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'memo',
            label: '备注',
            langtag: 'entities.hrarchivesmove.main_grid.columns.memo',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
    ]

    /**
     * 获取表格行模型
     *
     * @type {*}
     * @memberof MainGridBase
     */
    public getGridRowModel(){
        return {
          srfkey: new FormItemModel(),
        }
    }

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof MainGridBase
     */
    public rules: any = {
        srfkey: [
            { required: false, validator: (rule:any, value:any, callback:any) => { return (rule.required && (value === null || value === undefined || value === "")) ? false : true;}, message: '档案调档标识 值不能为空', trigger: 'change' },
            { required: false, validator: (rule:any, value:any, callback:any) => { return (rule.required && (value === null || value === undefined || value === "")) ? false : true;}, message: '档案调档标识 值不能为空', trigger: 'blur' },
        ],
    }

    /**
     * 获取对应列class
     *
     * @type {*}
     * @memberof MainBase
     */
    public hasRowEdit: any = {
        'movetype':false,
        'moveoutorg':false,
        'moveinorg':false,
        'activetime':false,
        'memo':false,
    };

    /**
     * 获取对应列class
     *
     * @param {*} $args row 行数据，column 列数据，rowIndex 行索引，列索引
     * @returns {void}
     * @memberof MainBase
     */
    public getCellClassName(args: {row: any, column: any, rowIndex: number, columnIndex: number}): any {
        return ( this.hasRowEdit[args.column.property] && this.actualIsOpenEdit ) ? "edit-cell" : "info-cell";
    }


    /**
     * 导出数据格式化
     *
     * @param {*} filterVal
     * @param {*} jsonData
     * @param {any[]} [codelistColumns=[]]
     * @returns {Promise<any>}
     * @memberof MainGridBase
     */
    public async formatExcelData(filterVal: any, jsonData: any, codelistColumns?: any[]): Promise<any> {
        return super.formatExcelData(filterVal, jsonData, [
            {
                name: 'movetype',
                srfkey: 'CL_HR_0025',
                codelistType : 'STATIC',
                renderMode: 'other',
                textSeparator: '、',
                valueSeparator: ',',
            },
        ]);
    }

}