import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 奖励惩罚服务对象基类
 *
 * @export
 * @class HRRewardServiceBase
 * @extends {EntityServie}
 */
export default class HRRewardServiceBase extends EntityService {

    /**
     * Creates an instance of  HRRewardServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  HRRewardServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof HRRewardServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='hrreward';
        this.APPDEKEY = 'hrrewardid';
        this.APPDENAME = 'hrrewards';
        this.APPDETEXT = 'hrrewardname';
        this.APPNAME = 'pim';
        this.SYSTEMNAME = 'ibizhumanresources';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof HRRewardServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.hremployee && context.hrreward){
            let res:any = Http.getInstance().get(`/hremployees/${context.hremployee}/hrrewards/${context.hrreward}/select`,isloading);
            
            return res;
        }
            let res:any = Http.getInstance().get(`/hrrewards/${context.hrreward}/select`,isloading);
            
            return res;
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof HRRewardServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.hremployee && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/hremployees/${context.hremployee}/hrrewards`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/hrrewards`,data,isloading);
        
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof HRRewardServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.hremployee && context.hrreward){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/hremployees/${context.hremployee}/hrrewards/${context.hrreward}`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/hrrewards/${context.hrreward}`,data,isloading);
            
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof HRRewardServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.hremployee && context.hrreward){
            let res:any = Http.getInstance().delete(`/hremployees/${context.hremployee}/hrrewards/${context.hrreward}`,isloading);
            return res;
        }
            let res:any = Http.getInstance().delete(`/hrrewards/${context.hrreward}`,isloading);
            return res;
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof HRRewardServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.hremployee && context.hrreward){
            let res:any = await Http.getInstance().get(`/hremployees/${context.hremployee}/hrrewards/${context.hrreward}`,isloading);
            
            return res;
        }
            let res:any = await Http.getInstance().get(`/hrrewards/${context.hrreward}`,isloading);
            
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof HRRewardServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.hremployee && true){
            let res:any = await Http.getInstance().get(`/hremployees/${context.hremployee}/hrrewards/getdraft`,isloading);
            res.data.hrreward = data.hrreward;
            
            return res;
        }
        let res:any = await  Http.getInstance().get(`/hrrewards/getdraft`,isloading);
        res.data.hrreward = data.hrreward;
        
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof HRRewardServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.hremployee && context.hrreward){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/hremployees/${context.hremployee}/hrrewards/${context.hrreward}/checkkey`,data,isloading);
            
            return res;
        }
            let res:any = Http.getInstance().post(`/hrrewards/${context.hrreward}/checkkey`,data,isloading);
            return res;
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof HRRewardServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.hremployee && context.hrreward){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/hremployees/${context.hremployee}/hrrewards/${context.hrreward}/save`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/hrrewards/${context.hrreward}/save`,data,isloading);
            
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof HRRewardServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.hremployee && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            let res:any = Http.getInstance().get(`/hremployees/${context.hremployee}/hrrewards/fetchdefault`,tempData,isloading);
            return res;
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/hrrewards/fetchdefault`,tempData,isloading);
        return res;
    }
}