import { Subject } from 'rxjs';
import { PickupViewBase } from '@/studio-core';
import HRPostService from '@/service/hrpost/hrpost-service';
import HRPostAuthService from '@/authservice/hrpost/hrpost-auth-service';
import PickupViewEngine from '@engine/view/pickup-view-engine';
import HRPostUIService from '@/uiservice/hrpost/hrpost-ui-service';

/**
 * 职位数据选择视图视图基类
 *
 * @export
 * @class HRPostPickupViewBase
 * @extends {PickupViewBase}
 */
export class HRPostPickupViewBase extends PickupViewBase {
    /**
     * 视图对应应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof HRPostPickupViewBase
     */
    protected appDeName: string = 'hrpost';

    /**
     * 应用实体主键
     *
     * @protected
     * @type {string}
     * @memberof HRPostPickupViewBase
     */
    protected appDeKey: string = 'hrpostid';

    /**
     * 应用实体主信息
     *
     * @protected
     * @type {string}
     * @memberof HRPostPickupViewBase
     */
    protected appDeMajor: string = 'hrpostname';

    /**
     * 实体服务对象
     *
     * @type {HRPostService}
     * @memberof HRPostPickupViewBase
     */
    protected appEntityService: HRPostService = new HRPostService;

    /**
     * 实体权限服务对象
     *
     * @type HRPostUIService
     * @memberof HRPostPickupViewBase
     */
    public appUIService: HRPostUIService = new HRPostUIService(this.$store);


    /**
     * 计数器服务对象集合
     *
     * @protected
     * @type {Array<*>}
     * @memberof HRPostPickupViewBase
     */    
    protected counterServiceArray: Array<any> = [];

    /**
     * 视图模型数据
     *
     * @protected
     * @type {*}
     * @memberof HRPostPickupViewBase
     */
    protected model: any = {
        srfCaption: 'entities.hrpost.views.pickupview.caption',
        srfTitle: 'entities.hrpost.views.pickupview.title',
        srfSubTitle: 'entities.hrpost.views.pickupview.subtitle',
        dataInfo: ''
    }

    /**
     * 容器模型
     *
     * @protected
     * @type {*}
     * @memberof HRPostPickupViewBase
     */
    protected containerModel: any = {
        view_pickupviewpanel: { name: 'pickupviewpanel', type: 'PICKUPVIEWPANEL' },
        view_okbtn: { name: 'okbtn', type: 'button', text: '确定', disabled: true },
        view_cancelbtn: { name: 'cancelbtn', type: 'button', text: '取消', disabled: false },
        view_leftbtn: { name: 'leftbtn', type: 'button', text: '左移', disabled: true },
        view_rightbtn: { name: 'rightbtn', type: 'button', text: '右移', disabled: true },
        view_allleftbtn: { name: 'allleftbtn', type: 'button', text: '全部左移', disabled: true },
        view_allrightbtn: { name: 'allrightbtn', type: 'button', text: '全部右移', disabled: true },
    };


	/**
     * 视图唯一标识
     *
     * @protected
     * @type {string}
     * @memberof ViewBase
     */
	protected viewtag: string = '04c02737ae62a4f4c014607441ee0401';


    /**
     * 视图引擎
     *
     * @public
     * @type {Engine}
     * @memberof HRPostPickupViewBase
     */
    public engine: PickupViewEngine = new PickupViewEngine();

    /**
     * 引擎初始化
     *
     * @public
     * @memberof HRPostPickupViewBase
     */
    public engineInit(): void {
        this.engine.init({
            view: this,
            pickupviewpanel: this.$refs.pickupviewpanel,
            keyPSDEField: 'hrpost',
            majorPSDEField: 'hrpostname',
            isLoadDefault: true,
        });
    }

    /**
     * pickupviewpanel 部件 selectionchange 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof HRPostPickupViewBase
     */
    public pickupviewpanel_selectionchange($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('pickupviewpanel', 'selectionchange', $event);
    }

    /**
     * pickupviewpanel 部件 activated 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof HRPostPickupViewBase
     */
    public pickupviewpanel_activated($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('pickupviewpanel', 'activated', $event);
    }

    /**
     * pickupviewpanel 部件 load 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof HRPostPickupViewBase
     */
    public pickupviewpanel_load($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('pickupviewpanel', 'load', $event);
    }


}