/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'endtime',
          prop: 'endtime',
          dataType: 'DATE',
        },
        {
          name: 'learnmodality',
          prop: 'learnmodality',
          dataType: 'SSCODELIST',
        },
        {
          name: 'firstdegreeflag',
          prop: 'firstdegreeflag',
          dataType: 'YESNO',
        },
        {
          name: 'begintime',
          prop: 'begintime',
          dataType: 'DATE',
        },
        {
          name: 'subject',
          prop: 'subject',
          dataType: 'TEXT',
        },
        {
          name: 'highdegreeflag',
          prop: 'highdegreeflag',
          dataType: 'YESNO',
        },
        {
          name: 'schooltype',
          prop: 'schooltype',
          dataType: 'SSCODELIST',
        },
        {
          name: 'srfmajortext',
          prop: 'hreducationname',
          dataType: 'TEXT',
        },
        {
          name: 'srfkey',
          prop: 'hreducationid',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'srfdataaccaction',
          prop: 'hreducationid',
          dataType: 'GUID',
        },
        {
          name: 'hremployeeid',
          prop: 'hremployeeid',
          dataType: 'PICKUP',
        },
        {
          name: 'degree',
          prop: 'degree',
          dataType: 'SSCODELIST',
        },
        {
          name: 'school',
          prop: 'school',
          dataType: 'TEXT',
        },
        {
          name: 'major',
          prop: 'major',
          dataType: 'TEXT',
        },
        {
          name: 'hreducation',
          prop: 'hreducationid',
        },

        {
          name:'size',
          prop:'size'
        },
        {
          name:'query',
          prop:'query'
        },
        {
          name:'filter',
          prop:'filter'
        },
        {
          name:'page',
          prop:'page'
        },
        {
          name:'sort',
          prop:'sort'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}