import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, GridControlBase } from '@/studio-core';
import HREducationService from '@/service/hreducation/hreducation-service';
import MainService from './main-grid-service';
import HREducationUIService from '@/uiservice/hreducation/hreducation-ui-service';
import { FormItemModel } from '@/model/form-detail';


/**
 * grid部件基类
 *
 * @export
 * @class GridControlBase
 * @extends {MainGridBase}
 */
export class MainGridBase extends GridControlBase {

    /**
     * 获取部件类型
     *
     * @protected
     * @type {string}
     * @memberof MainGridBase
     */
    protected controlType: string = 'GRID';

    /**
     * 建构部件服务对象
     *
     * @type {MainService}
     * @memberof MainGridBase
     */
    public service: MainService = new MainService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {HREducationService}
     * @memberof MainGridBase
     */
    public appEntityService: HREducationService = new HREducationService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof MainGridBase
     */
    protected appDeName: string = 'hreducation';

    /**
     * 应用实体中文名称
     *
     * @protected
     * @type {string}
     * @memberof MainGridBase
     */
    protected appDeLogicName: string = '教育信息';

    /**
     * 界面UI服务对象
     *
     * @type {HREducationUIService}
     * @memberof MainBase
     */  
    public appUIService:HREducationUIService = new HREducationUIService(this.$store);

    /**
     * 界面行为模型
     *
     * @type {*}
     * @memberof MainBase
     */  
    public ActionModel: any = {
    };

    /**
     * 本地缓存标识
     *
     * @protected
     * @type {string}
     * @memberof MainBase
     */
    protected localStorageTag: string = 'hreducation_main_grid';

    /**
     * 所有列成员
     *
     * @type {any[]}
     * @memberof MainGridBase
     */
    public allColumns: any[] = [
        {
            name: 'degree',
            label: '学历',
            langtag: 'entities.hreducation.main_grid.columns.degree',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'begintime',
            label: '入学时间',
            langtag: 'entities.hreducation.main_grid.columns.begintime',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'endtime',
            label: '毕业时间',
            langtag: 'entities.hreducation.main_grid.columns.endtime',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'school',
            label: '毕业院校',
            langtag: 'entities.hreducation.main_grid.columns.school',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'subject',
            label: '一级学科',
            langtag: 'entities.hreducation.main_grid.columns.subject',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'major',
            label: '专业',
            langtag: 'entities.hreducation.main_grid.columns.major',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'learnmodality',
            label: '学习形式',
            langtag: 'entities.hreducation.main_grid.columns.learnmodality',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'schooltype',
            label: '学校性质',
            langtag: 'entities.hreducation.main_grid.columns.schooltype',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'highdegreeflag',
            label: '是否最高学历',
            langtag: 'entities.hreducation.main_grid.columns.highdegreeflag',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'firstdegreeflag',
            label: '是否第一学历',
            langtag: 'entities.hreducation.main_grid.columns.firstdegreeflag',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
    ]

    /**
     * 获取表格行模型
     *
     * @type {*}
     * @memberof MainGridBase
     */
    public getGridRowModel(){
        return {
          srfkey: new FormItemModel(),
        }
    }

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof MainGridBase
     */
    public rules: any = {
        srfkey: [
            { required: false, validator: (rule:any, value:any, callback:any) => { return (rule.required && (value === null || value === undefined || value === "")) ? false : true;}, message: '教育信息标识 值不能为空', trigger: 'change' },
            { required: false, validator: (rule:any, value:any, callback:any) => { return (rule.required && (value === null || value === undefined || value === "")) ? false : true;}, message: '教育信息标识 值不能为空', trigger: 'blur' },
        ],
    }

    /**
     * 获取对应列class
     *
     * @type {*}
     * @memberof MainBase
     */
    public hasRowEdit: any = {
        'degree':false,
        'begintime':false,
        'endtime':false,
        'school':false,
        'subject':false,
        'major':false,
        'learnmodality':false,
        'schooltype':false,
        'highdegreeflag':false,
        'firstdegreeflag':false,
    };

    /**
     * 获取对应列class
     *
     * @param {*} $args row 行数据，column 列数据，rowIndex 行索引，列索引
     * @returns {void}
     * @memberof MainBase
     */
    public getCellClassName(args: {row: any, column: any, rowIndex: number, columnIndex: number}): any {
        return ( this.hasRowEdit[args.column.property] && this.actualIsOpenEdit ) ? "edit-cell" : "info-cell";
    }


    /**
     * 导出数据格式化
     *
     * @param {*} filterVal
     * @param {*} jsonData
     * @param {any[]} [codelistColumns=[]]
     * @returns {Promise<any>}
     * @memberof MainGridBase
     */
    public async formatExcelData(filterVal: any, jsonData: any, codelistColumns?: any[]): Promise<any> {
        return super.formatExcelData(filterVal, jsonData, [
            {
                name: 'degree',
                srfkey: 'CL_HR_0014',
                codelistType : 'STATIC',
                renderMode: 'other',
                textSeparator: '、',
                valueSeparator: ',',
            },
            {
                name: 'highdegreeflag',
                srfkey: 'YesNo',
                codelistType : 'STATIC',
                renderMode: 'other',
                textSeparator: '、',
                valueSeparator: ',',
            },
            {
                name: 'firstdegreeflag',
                srfkey: 'YesNo',
                codelistType : 'STATIC',
                renderMode: 'other',
                textSeparator: '、',
                valueSeparator: ',',
            },
        ]);
    }

}