import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 组织联系信息服务对象基类
 *
 * @export
 * @class HROrgContactServiceBase
 * @extends {EntityServie}
 */
export default class HROrgContactServiceBase extends EntityService {

    /**
     * Creates an instance of  HROrgContactServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  HROrgContactServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof HROrgContactServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='hrorgcontact';
        this.APPDEKEY = 'hrorgcontactid';
        this.APPDENAME = 'hrorgcontacts';
        this.APPDETEXT = 'hrorgcontactname';
        this.APPNAME = 'pim';
        this.SYSTEMNAME = 'ibizhumanresources';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof HROrgContactServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.hroperationunit && context.hrorgcontact){
            let res:any = Http.getInstance().get(`/hroperationunits/${context.hroperationunit}/hrorgcontacts/${context.hrorgcontact}/select`,isloading);
            
            return res;
        }
        if(context.hrlegal && context.hrorgcontact){
            let res:any = Http.getInstance().get(`/hrlegals/${context.hrlegal}/hrorgcontacts/${context.hrorgcontact}/select`,isloading);
            
            return res;
        }
            let res:any = Http.getInstance().get(`/hrorgcontacts/${context.hrorgcontact}/select`,isloading);
            
            return res;
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof HROrgContactServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.hroperationunit && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/hroperationunits/${context.hroperationunit}/hrorgcontacts`,data,isloading);
            
            return res;
        }
        if(context.hrlegal && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/hrlegals/${context.hrlegal}/hrorgcontacts`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/hrorgcontacts`,data,isloading);
        
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof HROrgContactServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.hroperationunit && context.hrorgcontact){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/hroperationunits/${context.hroperationunit}/hrorgcontacts/${context.hrorgcontact}`,data,isloading);
            
            return res;
        }
        if(context.hrlegal && context.hrorgcontact){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/hrlegals/${context.hrlegal}/hrorgcontacts/${context.hrorgcontact}`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/hrorgcontacts/${context.hrorgcontact}`,data,isloading);
            
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof HROrgContactServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.hroperationunit && context.hrorgcontact){
            let res:any = Http.getInstance().delete(`/hroperationunits/${context.hroperationunit}/hrorgcontacts/${context.hrorgcontact}`,isloading);
            return res;
        }
        if(context.hrlegal && context.hrorgcontact){
            let res:any = Http.getInstance().delete(`/hrlegals/${context.hrlegal}/hrorgcontacts/${context.hrorgcontact}`,isloading);
            return res;
        }
            let res:any = Http.getInstance().delete(`/hrorgcontacts/${context.hrorgcontact}`,isloading);
            return res;
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof HROrgContactServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.hroperationunit && context.hrorgcontact){
            let res:any = await Http.getInstance().get(`/hroperationunits/${context.hroperationunit}/hrorgcontacts/${context.hrorgcontact}`,isloading);
            
            return res;
        }
        if(context.hrlegal && context.hrorgcontact){
            let res:any = await Http.getInstance().get(`/hrlegals/${context.hrlegal}/hrorgcontacts/${context.hrorgcontact}`,isloading);
            
            return res;
        }
            let res:any = await Http.getInstance().get(`/hrorgcontacts/${context.hrorgcontact}`,isloading);
            
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof HROrgContactServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.hroperationunit && true){
            let res:any = await Http.getInstance().get(`/hroperationunits/${context.hroperationunit}/hrorgcontacts/getdraft`,isloading);
            res.data.hrorgcontact = data.hrorgcontact;
            
            return res;
        }
        if(context.hrlegal && true){
            let res:any = await Http.getInstance().get(`/hrlegals/${context.hrlegal}/hrorgcontacts/getdraft`,isloading);
            res.data.hrorgcontact = data.hrorgcontact;
            
            return res;
        }
        let res:any = await  Http.getInstance().get(`/hrorgcontacts/getdraft`,isloading);
        res.data.hrorgcontact = data.hrorgcontact;
        
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof HROrgContactServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.hroperationunit && context.hrorgcontact){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/hroperationunits/${context.hroperationunit}/hrorgcontacts/${context.hrorgcontact}/checkkey`,data,isloading);
            
            return res;
        }
        if(context.hrlegal && context.hrorgcontact){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/hrlegals/${context.hrlegal}/hrorgcontacts/${context.hrorgcontact}/checkkey`,data,isloading);
            
            return res;
        }
            let res:any = Http.getInstance().post(`/hrorgcontacts/${context.hrorgcontact}/checkkey`,data,isloading);
            return res;
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof HROrgContactServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.hroperationunit && context.hrorgcontact){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/hroperationunits/${context.hroperationunit}/hrorgcontacts/${context.hrorgcontact}/save`,data,isloading);
            
            return res;
        }
        if(context.hrlegal && context.hrorgcontact){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/hrlegals/${context.hrlegal}/hrorgcontacts/${context.hrorgcontact}/save`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/hrorgcontacts/${context.hrorgcontact}/save`,data,isloading);
            
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof HROrgContactServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.hroperationunit && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            let res:any = Http.getInstance().get(`/hroperationunits/${context.hroperationunit}/hrorgcontacts/fetchdefault`,tempData,isloading);
            return res;
        }
        if(context.hrlegal && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            let res:any = Http.getInstance().get(`/hrlegals/${context.hrlegal}/hrorgcontacts/fetchdefault`,tempData,isloading);
            return res;
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/hrorgcontacts/fetchdefault`,tempData,isloading);
        return res;
    }
}