import AuthService from '../auth-service';

/**
 * 工作人员分配权限服务对象基类
 *
 * @export
 * @class HRDistributionAuthServiceBase
 * @extends {AuthService}
 */
export default class HRDistributionAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  HRDistributionAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  HRDistributionAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof HRDistributionAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}