import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, GridControlBase } from '@/studio-core';
import HRTransferApplyService from '@/service/hrtransfer-apply/hrtransfer-apply-service';
import MainService from './main-grid-service';
import HRTransferApplyUIService from '@/uiservice/hrtransfer-apply/hrtransfer-apply-ui-service';
import { FormItemModel } from '@/model/form-detail';


/**
 * grid部件基类
 *
 * @export
 * @class GridControlBase
 * @extends {MainGridBase}
 */
export class MainGridBase extends GridControlBase {

    /**
     * 获取部件类型
     *
     * @protected
     * @type {string}
     * @memberof MainGridBase
     */
    protected controlType: string = 'GRID';

    /**
     * 建构部件服务对象
     *
     * @type {MainService}
     * @memberof MainGridBase
     */
    public service: MainService = new MainService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {HRTransferApplyService}
     * @memberof MainGridBase
     */
    public appEntityService: HRTransferApplyService = new HRTransferApplyService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof MainGridBase
     */
    protected appDeName: string = 'hrtransferapply';

    /**
     * 应用实体中文名称
     *
     * @protected
     * @type {string}
     * @memberof MainGridBase
     */
    protected appDeLogicName: string = '调动申请';

    /**
     * 界面UI服务对象
     *
     * @type {HRTransferApplyUIService}
     * @memberof MainBase
     */  
    public appUIService:HRTransferApplyUIService = new HRTransferApplyUIService(this.$store);

    /**
     * 界面行为模型
     *
     * @type {*}
     * @memberof MainBase
     */  
    public ActionModel: any = {
    };

    /**
     * 本地缓存标识
     *
     * @protected
     * @type {string}
     * @memberof MainBase
     */
    protected localStorageTag: string = 'hrtransferapply_main_grid';

    /**
     * 所有列成员
     *
     * @type {any[]}
     * @memberof MainGridBase
     */
    public allColumns: any[] = [
        {
            name: 'hremployeename',
            label: '员工姓名',
            langtag: 'entities.hrtransferapply.main_grid.columns.hremployeename',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'organizationname',
            label: '部门',
            langtag: 'entities.hrtransferapply.main_grid.columns.organizationname',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'hrpostname',
            label: '职位',
            langtag: 'entities.hrtransferapply.main_grid.columns.hrpostname',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'hrdutyname',
            label: '职务',
            langtag: 'entities.hrtransferapply.main_grid.columns.hrdutyname',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'hrorganizationname2',
            label: '新部门',
            langtag: 'entities.hrtransferapply.main_grid.columns.hrorganizationname2',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'hrpostname2',
            label: '新职位',
            langtag: 'entities.hrtransferapply.main_grid.columns.hrpostname2',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'hrdutyname2',
            label: '新职务',
            langtag: 'entities.hrtransferapply.main_grid.columns.hrdutyname2',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'activetime',
            label: '生效日期',
            langtag: 'entities.hrtransferapply.main_grid.columns.activetime',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
    ]

    /**
     * 获取表格行模型
     *
     * @type {*}
     * @memberof MainGridBase
     */
    public getGridRowModel(){
        return {
          srfkey: new FormItemModel(),
        }
    }

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof MainGridBase
     */
    public rules: any = {
        srfkey: [
            { required: false, validator: (rule:any, value:any, callback:any) => { return (rule.required && (value === null || value === undefined || value === "")) ? false : true;}, message: '调动申请标识 值不能为空', trigger: 'change' },
            { required: false, validator: (rule:any, value:any, callback:any) => { return (rule.required && (value === null || value === undefined || value === "")) ? false : true;}, message: '调动申请标识 值不能为空', trigger: 'blur' },
        ],
    }

    /**
     * 获取对应列class
     *
     * @type {*}
     * @memberof MainBase
     */
    public hasRowEdit: any = {
        'hremployeename':false,
        'organizationname':false,
        'hrpostname':false,
        'hrdutyname':false,
        'hrorganizationname2':false,
        'hrpostname2':false,
        'hrdutyname2':false,
        'activetime':false,
    };

    /**
     * 获取对应列class
     *
     * @param {*} $args row 行数据，column 列数据，rowIndex 行索引，列索引
     * @returns {void}
     * @memberof MainBase
     */
    public getCellClassName(args: {row: any, column: any, rowIndex: number, columnIndex: number}): any {
        return ( this.hasRowEdit[args.column.property] && this.actualIsOpenEdit ) ? "edit-cell" : "info-cell";
    }


    /**
     * 导出数据格式化
     *
     * @param {*} filterVal
     * @param {*} jsonData
     * @param {any[]} [codelistColumns=[]]
     * @returns {Promise<any>}
     * @memberof MainGridBase
     */
    public async formatExcelData(filterVal: any, jsonData: any, codelistColumns?: any[]): Promise<any> {
        return super.formatExcelData(filterVal, jsonData, [
        ]);
    }

}