/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'rewardlevel',
          prop: 'rewardlevel',
          dataType: 'SSCODELIST',
        },
        {
          name: 'hremployeeid',
          prop: 'hremployeeid',
          dataType: 'PICKUP',
        },
        {
          name: 'rewardmoney',
          prop: 'rewardmoney',
          dataType: 'DECIMAL',
        },
        {
          name: 'rewardtype',
          prop: 'rewardtype',
          dataType: 'SSCODELIST',
        },
        {
          name: 'rewardevent',
          prop: 'rewardevent',
          dataType: 'LONGTEXT_1000',
        },
        {
          name: 'hrrewardname',
          prop: 'hrrewardname',
          dataType: 'TEXT',
        },
        {
          name: 'rewardtime',
          prop: 'rewardtime',
          dataType: 'DATE',
        },
        {
          name: 'srfmajortext',
          prop: 'hrrewardname',
          dataType: 'TEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'hrrewardid',
          dataType: 'GUID',
        },
        {
          name: 'srfkey',
          prop: 'hrrewardid',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'hrreward',
          prop: 'hrrewardid',
        },

        {
          name:'size',
          prop:'size'
        },
        {
          name:'query',
          prop:'query'
        },
        {
          name:'filter',
          prop:'filter'
        },
        {
          name:'page',
          prop:'page'
        },
        {
          name:'sort',
          prop:'sort'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}