import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, GridControlBase } from '@/studio-core';
import HRFamilyService from '@/service/hrfamily/hrfamily-service';
import MainService from './main-grid-service';
import HRFamilyUIService from '@/uiservice/hrfamily/hrfamily-ui-service';
import { FormItemModel } from '@/model/form-detail';


/**
 * grid部件基类
 *
 * @export
 * @class GridControlBase
 * @extends {MainGridBase}
 */
export class MainGridBase extends GridControlBase {

    /**
     * 获取部件类型
     *
     * @protected
     * @type {string}
     * @memberof MainGridBase
     */
    protected controlType: string = 'GRID';

    /**
     * 建构部件服务对象
     *
     * @type {MainService}
     * @memberof MainGridBase
     */
    public service: MainService = new MainService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {HRFamilyService}
     * @memberof MainGridBase
     */
    public appEntityService: HRFamilyService = new HRFamilyService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof MainGridBase
     */
    protected appDeName: string = 'hrfamily';

    /**
     * 应用实体中文名称
     *
     * @protected
     * @type {string}
     * @memberof MainGridBase
     */
    protected appDeLogicName: string = '家庭情况';

    /**
     * 界面UI服务对象
     *
     * @type {HRFamilyUIService}
     * @memberof MainBase
     */  
    public appUIService:HRFamilyUIService = new HRFamilyUIService(this.$store);

    /**
     * 界面行为模型
     *
     * @type {*}
     * @memberof MainBase
     */  
    public ActionModel: any = {
    };

    /**
     * 本地缓存标识
     *
     * @protected
     * @type {string}
     * @memberof MainBase
     */
    protected localStorageTag: string = 'hrfamily_main_grid';

    /**
     * 所有列成员
     *
     * @type {any[]}
     * @memberof MainGridBase
     */
    public allColumns: any[] = [
        {
            name: 'relationship',
            label: '与本人关系',
            langtag: 'entities.hrfamily.main_grid.columns.relationship',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'hrfamilyname',
            label: '姓名',
            langtag: 'entities.hrfamily.main_grid.columns.hrfamilyname',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'sex',
            label: '性别',
            langtag: 'entities.hrfamily.main_grid.columns.sex',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'certtype',
            label: '证件类型',
            langtag: 'entities.hrfamily.main_grid.columns.certtype',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'certnum',
            label: '证件号码',
            langtag: 'entities.hrfamily.main_grid.columns.certnum',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'birthday',
            label: '出生日期',
            langtag: 'entities.hrfamily.main_grid.columns.birthday',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'age',
            label: '年龄',
            langtag: 'entities.hrfamily.main_grid.columns.age',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'workorganization',
            label: '工作单位',
            langtag: 'entities.hrfamily.main_grid.columns.workorganization',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'duty',
            label: '职务',
            langtag: 'entities.hrfamily.main_grid.columns.duty',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'political',
            label: '政治面貌',
            langtag: 'entities.hrfamily.main_grid.columns.political',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'emergencyflag',
            label: '是否紧急联系人',
            langtag: 'entities.hrfamily.main_grid.columns.emergencyflag',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
    ]

    /**
     * 获取表格行模型
     *
     * @type {*}
     * @memberof MainGridBase
     */
    public getGridRowModel(){
        return {
          srfkey: new FormItemModel(),
        }
    }

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof MainGridBase
     */
    public rules: any = {
        srfkey: [
            { required: false, validator: (rule:any, value:any, callback:any) => { return (rule.required && (value === null || value === undefined || value === "")) ? false : true;}, message: '家庭情况标识 值不能为空', trigger: 'change' },
            { required: false, validator: (rule:any, value:any, callback:any) => { return (rule.required && (value === null || value === undefined || value === "")) ? false : true;}, message: '家庭情况标识 值不能为空', trigger: 'blur' },
        ],
    }

    /**
     * 获取对应列class
     *
     * @type {*}
     * @memberof MainBase
     */
    public hasRowEdit: any = {
        'relationship':false,
        'hrfamilyname':false,
        'sex':false,
        'certtype':false,
        'certnum':false,
        'birthday':false,
        'age':false,
        'workorganization':false,
        'duty':false,
        'political':false,
        'emergencyflag':false,
    };

    /**
     * 获取对应列class
     *
     * @param {*} $args row 行数据，column 列数据，rowIndex 行索引，列索引
     * @returns {void}
     * @memberof MainBase
     */
    public getCellClassName(args: {row: any, column: any, rowIndex: number, columnIndex: number}): any {
        return ( this.hasRowEdit[args.column.property] && this.actualIsOpenEdit ) ? "edit-cell" : "info-cell";
    }


    /**
     * 导出数据格式化
     *
     * @param {*} filterVal
     * @param {*} jsonData
     * @param {any[]} [codelistColumns=[]]
     * @returns {Promise<any>}
     * @memberof MainGridBase
     */
    public async formatExcelData(filterVal: any, jsonData: any, codelistColumns?: any[]): Promise<any> {
        return super.formatExcelData(filterVal, jsonData, [
            {
                name: 'sex',
                srfkey: 'CL_HR_0010',
                codelistType : 'STATIC',
                renderMode: 'other',
                textSeparator: '、',
                valueSeparator: ',',
            },
            {
                name: 'certtype',
                srfkey: 'CL_HR_0009',
                codelistType : 'STATIC',
                renderMode: 'other',
                textSeparator: '、',
                valueSeparator: ',',
            },
            {
                name: 'political',
                srfkey: 'CL_HR_0013',
                codelistType : 'STATIC',
                renderMode: 'other',
                textSeparator: '、',
                valueSeparator: ',',
            },
            {
                name: 'emergencyflag',
                srfkey: 'YesNo',
                codelistType : 'STATIC',
                renderMode: 'other',
                textSeparator: '、',
                valueSeparator: ',',
            },
        ]);
    }

}