import AuthService from '../auth-service';

/**
 * 奖励惩罚权限服务对象基类
 *
 * @export
 * @class HRRewardAuthServiceBase
 * @extends {AuthService}
 */
export default class HRRewardAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  HRRewardAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  HRRewardAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof HRRewardAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}