import AuthService from '../auth-service';

/**
 * 组织联系信息权限服务对象基类
 *
 * @export
 * @class HROrgContactAuthServiceBase
 * @extends {AuthService}
 */
export default class HROrgContactAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  HROrgContactAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  HROrgContactAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof HROrgContactAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}