import AuthService from '../auth-service';

/**
 * 档案调档权限服务对象基类
 *
 * @export
 * @class HRArchivesMoveAuthServiceBase
 * @extends {AuthService}
 */
export default class HRArchivesMoveAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  HRArchivesMoveAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  HRArchivesMoveAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof HRArchivesMoveAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}