/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'birthday',
          prop: 'birthday',
          dataType: 'DATE',
        },
        {
          name: 'workorganization',
          prop: 'workorganization',
          dataType: 'TEXT',
        },
        {
          name: 'sex',
          prop: 'sex',
          dataType: 'SSCODELIST',
        },
        {
          name: 'political',
          prop: 'political',
          dataType: 'SSCODELIST',
        },
        {
          name: 'emergencyflag',
          prop: 'emergencyflag',
          dataType: 'YESNO',
        },
        {
          name: 'hrfamilyname',
          prop: 'hrfamilyname',
          dataType: 'TEXT',
        },
        {
          name: 'srfmajortext',
          prop: 'hrfamilyname',
          dataType: 'TEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'hrfamilyid',
          dataType: 'GUID',
        },
        {
          name: 'srfkey',
          prop: 'hrfamilyid',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'relationship',
          prop: 'relationship',
          dataType: 'SSCODELIST',
        },
        {
          name: 'hremployeeid',
          prop: 'hremployeeid',
          dataType: 'PICKUP',
        },
        {
          name: 'duty',
          prop: 'duty',
          dataType: 'TEXT',
        },
        {
          name: 'certtype',
          prop: 'certtype',
          dataType: 'SSCODELIST',
        },
        {
          name: 'age',
          prop: 'age',
          dataType: 'TEXT',
        },
        {
          name: 'certnum',
          prop: 'certnum',
          dataType: 'TEXT',
        },
        {
          name: 'hrfamily',
          prop: 'hrfamilyid',
        },

        {
          name:'size',
          prop:'size'
        },
        {
          name:'query',
          prop:'query'
        },
        {
          name:'filter',
          prop:'filter'
        },
        {
          name:'page',
          prop:'page'
        },
        {
          name:'sort',
          prop:'sort'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}