import AuthService from '../auth-service';

/**
 * 调动申请权限服务对象基类
 *
 * @export
 * @class HRTransferApplyAuthServiceBase
 * @extends {AuthService}
 */
export default class HRTransferApplyAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  HRTransferApplyAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  HRTransferApplyAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof HRTransferApplyAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}