/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'hrorganizationname',
          prop: 'hrorganizationname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'hrdutyname',
          prop: 'hrdutyname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'hrpostname',
          prop: 'hrpostname',
          dataType: 'TEXT',
        },
        {
          name: 'hrorganizationid',
          prop: 'hrorganizationid',
          dataType: 'PICKUP',
        },
        {
          name: 'activeflag',
          prop: 'activeflag',
          dataType: 'YESNO',
        },
        {
          name: 'posttype',
          prop: 'posttype',
          dataType: 'SSCODELIST',
        },
        {
          name: 'postcode',
          prop: 'postcode',
          dataType: 'TEXT',
        },
        {
          name: 'postnum',
          prop: 'postnum',
          dataType: 'BIGINT',
        },
        {
          name: 'srfmajortext',
          prop: 'hrpostname',
          dataType: 'TEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'hrpostid',
          dataType: 'GUID',
        },
        {
          name: 'srfkey',
          prop: 'hrpostid',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'hrdutyid',
          prop: 'hrdutyid',
          dataType: 'PICKUP',
        },
        {
          name: 'hrpost',
          prop: 'hrpostid',
        },

        {
          name:'size',
          prop:'size'
        },
        {
          name:'query',
          prop:'query'
        },
        {
          name:'filter',
          prop:'filter'
        },
        {
          name:'page',
          prop:'page'
        },
        {
          name:'sort',
          prop:'sort'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}