import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, GridControlBase } from '@/studio-core';
import HRPostService from '@/service/hrpost/hrpost-service';
import MainService from './main-grid-service';
import HRPostUIService from '@/uiservice/hrpost/hrpost-ui-service';
import { FormItemModel } from '@/model/form-detail';


/**
 * grid部件基类
 *
 * @export
 * @class GridControlBase
 * @extends {MainGridBase}
 */
export class MainGridBase extends GridControlBase {

    /**
     * 获取部件类型
     *
     * @protected
     * @type {string}
     * @memberof MainGridBase
     */
    protected controlType: string = 'GRID';

    /**
     * 建构部件服务对象
     *
     * @type {MainService}
     * @memberof MainGridBase
     */
    public service: MainService = new MainService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {HRPostService}
     * @memberof MainGridBase
     */
    public appEntityService: HRPostService = new HRPostService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof MainGridBase
     */
    protected appDeName: string = 'hrpost';

    /**
     * 应用实体中文名称
     *
     * @protected
     * @type {string}
     * @memberof MainGridBase
     */
    protected appDeLogicName: string = '职位';

    /**
     * 界面UI服务对象
     *
     * @type {HRPostUIService}
     * @memberof MainBase
     */  
    public appUIService:HRPostUIService = new HRPostUIService(this.$store);

    /**
     * 界面行为模型
     *
     * @type {*}
     * @memberof MainBase
     */  
    public ActionModel: any = {
    };

    /**
     * 本地缓存标识
     *
     * @protected
     * @type {string}
     * @memberof MainBase
     */
    protected localStorageTag: string = 'hrpost_main_grid';

    /**
     * 所有列成员
     *
     * @type {any[]}
     * @memberof MainGridBase
     */
    public allColumns: any[] = [
        {
            name: 'postcode',
            label: '编号',
            langtag: 'entities.hrpost.main_grid.columns.postcode',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'hrpostname',
            label: '职位',
            langtag: 'entities.hrpost.main_grid.columns.hrpostname',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'hrdutyname',
            label: '职务',
            langtag: 'entities.hrpost.main_grid.columns.hrdutyname',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'posttype',
            label: '职位类型',
            langtag: 'entities.hrpost.main_grid.columns.posttype',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'hrorganizationname',
            label: '部门',
            langtag: 'entities.hrpost.main_grid.columns.hrorganizationname',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'postnum',
            label: '编制人数',
            langtag: 'entities.hrpost.main_grid.columns.postnum',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'activeflag',
            label: '是否有效',
            langtag: 'entities.hrpost.main_grid.columns.activeflag',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
    ]

    /**
     * 获取表格行模型
     *
     * @type {*}
     * @memberof MainGridBase
     */
    public getGridRowModel(){
        return {
          srfkey: new FormItemModel(),
        }
    }

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof MainGridBase
     */
    public rules: any = {
        srfkey: [
            { required: false, validator: (rule:any, value:any, callback:any) => { return (rule.required && (value === null || value === undefined || value === "")) ? false : true;}, message: '职位标识 值不能为空', trigger: 'change' },
            { required: false, validator: (rule:any, value:any, callback:any) => { return (rule.required && (value === null || value === undefined || value === "")) ? false : true;}, message: '职位标识 值不能为空', trigger: 'blur' },
        ],
    }

    /**
     * 获取对应列class
     *
     * @type {*}
     * @memberof MainBase
     */
    public hasRowEdit: any = {
        'postcode':false,
        'hrpostname':false,
        'hrdutyname':false,
        'posttype':false,
        'hrorganizationname':false,
        'postnum':false,
        'activeflag':false,
    };

    /**
     * 获取对应列class
     *
     * @param {*} $args row 行数据，column 列数据，rowIndex 行索引，列索引
     * @returns {void}
     * @memberof MainBase
     */
    public getCellClassName(args: {row: any, column: any, rowIndex: number, columnIndex: number}): any {
        return ( this.hasRowEdit[args.column.property] && this.actualIsOpenEdit ) ? "edit-cell" : "info-cell";
    }


    /**
     * 导出数据格式化
     *
     * @param {*} filterVal
     * @param {*} jsonData
     * @param {any[]} [codelistColumns=[]]
     * @returns {Promise<any>}
     * @memberof MainGridBase
     */
    public async formatExcelData(filterVal: any, jsonData: any, codelistColumns?: any[]): Promise<any> {
        return super.formatExcelData(filterVal, jsonData, [
            {
                name: 'posttype',
                srfkey: 'CL_HR_0004',
                codelistType : 'STATIC',
                renderMode: 'other',
                textSeparator: '、',
                valueSeparator: ',',
            },
            {
                name: 'activeflag',
                srfkey: 'YesNo',
                codelistType : 'STATIC',
                renderMode: 'other',
                textSeparator: '、',
                valueSeparator: ',',
            },
        ]);
    }

}