/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'wfversion',
          prop: 'wfversion',
          dataType: 'TEXT',
        },
        {
          name: 'organizationname',
          prop: 'organizationname',
          dataType: 'PICKUPDATA',
        },
        {
          name: 'srfwfver',
          prop: 'wfversion',
          dataType: 'TEXT',
        },
        {
          name: 'hrdutyname2',
          prop: 'hrdutyname2',
          dataType: 'PICKUPDATA',
        },
        {
          name: 'hrpostname',
          prop: 'hrpostname',
          dataType: 'PICKUPDATA',
        },
        {
          name: 'hrdutyname',
          prop: 'hrdutyname',
          dataType: 'PICKUPDATA',
        },
        {
          name: 'hrorganizationname2',
          prop: 'hrorganizationname2',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'wfstep',
          prop: 'wfstep',
          dataType: 'SSCODELIST',
        },
        {
          name: 'hrorganizationid2',
          prop: 'hrorganizationid2',
          dataType: 'PICKUP',
        },
        {
          name: 'hrpostid2',
          prop: 'hrpostid2',
          dataType: 'PICKUP',
        },
        {
          name: 'srfmajortext',
          prop: 'hrtransferapplyname',
          dataType: 'TEXT',
        },
        {
          name: 'srfkey',
          prop: 'hrtransferapplyid',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'srfdataaccaction',
          prop: 'hrtransferapplyid',
          dataType: 'GUID',
        },
        {
          name: 'hremployeeid',
          prop: 'hremployeeid',
          dataType: 'PICKUP',
        },
        {
          name: 'hremployeename',
          prop: 'hremployeename',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'checkstatus',
          prop: 'checkstatus',
          dataType: 'SSCODELIST',
        },
        {
          name: 'srfwfstep',
          prop: 'wfstep',
          dataType: 'SSCODELIST',
        },
        {
          name: 'activetime',
          prop: 'activetime',
          dataType: 'DATE',
        },
        {
          name: 'hrpostname2',
          prop: 'hrpostname2',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'hrtransferapply',
          prop: 'hrtransferapplyid',
        },

        {
          name:'size',
          prop:'size'
        },
        {
          name:'query',
          prop:'query'
        },
        {
          name:'filter',
          prop:'filter'
        },
        {
          name:'page',
          prop:'page'
        },
        {
          name:'sort',
          prop:'sort'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}