import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, EditFormControlBase } from '@/studio-core';
import HRTransferApplyService from '@/service/hrtransfer-apply/hrtransfer-apply-service';
import MainService from './main-form-service';
import HRTransferApplyUIService from '@/uiservice/hrtransfer-apply/hrtransfer-apply-ui-service';
import { FormButtonModel, FormPageModel, FormItemModel, FormDRUIPartModel, FormPartModel, FormGroupPanelModel, FormIFrameModel, FormRowItemModel, FormTabPageModel, FormTabPanelModel, FormUserControlModel } from '@/model/form-detail';


/**
 * form部件基类
 *
 * @export
 * @class EditFormControlBase
 * @extends {MainEditFormBase}
 */
export class MainEditFormBase extends EditFormControlBase {

    /**
     * 获取部件类型
     *
     * @protected
     * @type {string}
     * @memberof MainEditFormBase
     */
    protected controlType: string = 'FORM';

    /**
     * 建构部件服务对象
     *
     * @type {MainService}
     * @memberof MainEditFormBase
     */
    public service: MainService = new MainService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {HRTransferApplyService}
     * @memberof MainEditFormBase
     */
    public appEntityService: HRTransferApplyService = new HRTransferApplyService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof MainEditFormBase
     */
    protected appDeName: string = 'hrtransferapply';

    /**
     * 应用实体中文名称
     *
     * @protected
     * @type {string}
     * @memberof MainEditFormBase
     */
    protected appDeLogicName: string = '调动申请';
    /**
     * 界面UI服务对象
     *
     * @type {HRTransferApplyUIService}
     * @memberof MainEditFormBase
     */  
    public appUIService:HRTransferApplyUIService = new HRTransferApplyUIService(this.$store);


    /**
     * 表单数据对象
     *
     * @type {*}
     * @memberof MainEditFormBase
     */
    public data: any = {
        srfupdatedate: null,
        srforikey: null,
        srfkey: null,
        srfmajortext: null,
        srftempmode: null,
        srfuf: null,
        srfdeid: null,
        srfsourcekey: null,
        hremployeename: null,
        organizationname: null,
        hrpostname: null,
        hrdutyname: null,
        hrorganizationname2: null,
        hrpostname2: null,
        hrdutyname2: null,
        activetime: null,
        attachment: null,
        hrorganizationid2: null,
        hrpostid2: null,
        hremployeeid: null,
        organizationid: null,
        wfinstanceid: null,
        checkstatus: null,
        wfstate: null,
        wfversion: null,
        wfstep: null,
        hrtransferapplyid: null,
        hrtransferapply:null,
    };

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof MainEditFormBase
     */
    public rules: any = {
    }

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof MainBase
     */
    public deRules:any = {
    };

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof MainEditFormBase
     */
    public detailsModel: any = {
        group1: new FormGroupPanelModel({ caption: '调动申请基本信息', detailType: 'GROUPPANEL', name: 'group1', visible: true, isShowCaption: false, form: this, showMoreMode: 0, uiActionGroup: { caption: '', langbase: 'entities.hrtransferapply.main_form', extractMode: 'ITEM', details: [] } }),

        formpage1: new FormPageModel({ caption: '基本信息', detailType: 'FORMPAGE', name: 'formpage1', visible: true, isShowCaption: true, form: this, showMoreMode: 0 }),

        srfupdatedate: new FormItemModel({ caption: '更新时间', detailType: 'FORMITEM', name: 'srfupdatedate', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srforikey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srforikey', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfkey: new FormItemModel({ caption: '调动申请标识', detailType: 'FORMITEM', name: 'srfkey', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfmajortext: new FormItemModel({ caption: '调动申请名称', detailType: 'FORMITEM', name: 'srfmajortext', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srftempmode: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srftempmode', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfuf: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfuf', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfdeid: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfdeid', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfsourcekey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfsourcekey', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        hremployeename: new FormItemModel({ caption: '员工姓名', detailType: 'FORMITEM', name: 'hremployeename', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        organizationname: new FormItemModel({ caption: '部门', detailType: 'FORMITEM', name: 'organizationname', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        hrpostname: new FormItemModel({ caption: '职位', detailType: 'FORMITEM', name: 'hrpostname', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        hrdutyname: new FormItemModel({ caption: '职务', detailType: 'FORMITEM', name: 'hrdutyname', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        hrorganizationname2: new FormItemModel({ caption: '新部门', detailType: 'FORMITEM', name: 'hrorganizationname2', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        hrpostname2: new FormItemModel({ caption: '新职位', detailType: 'FORMITEM', name: 'hrpostname2', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        hrdutyname2: new FormItemModel({ caption: '新职务', detailType: 'FORMITEM', name: 'hrdutyname2', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        activetime: new FormItemModel({ caption: '生效日期', detailType: 'FORMITEM', name: 'activetime', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        attachment: new FormItemModel({ caption: '任职文件', detailType: 'FORMITEM', name: 'attachment', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        hrorganizationid2: new FormItemModel({ caption: '新组织ID', detailType: 'FORMITEM', name: 'hrorganizationid2', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        hrpostid2: new FormItemModel({ caption: '新职位标识', detailType: 'FORMITEM', name: 'hrpostid2', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        hremployeeid: new FormItemModel({ caption: '员工标识', detailType: 'FORMITEM', name: 'hremployeeid', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        organizationid: new FormItemModel({ caption: '部门ID', detailType: 'FORMITEM', name: 'organizationid', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        wfinstanceid: new FormItemModel({ caption: '工作流实例', detailType: 'FORMITEM', name: 'wfinstanceid', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        checkstatus: new FormItemModel({ caption: '工作流业务状态', detailType: 'FORMITEM', name: 'checkstatus', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        wfstate: new FormItemModel({ caption: '工作流状态', detailType: 'FORMITEM', name: 'wfstate', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        wfversion: new FormItemModel({ caption: '工作流版本', detailType: 'FORMITEM', name: 'wfversion', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        wfstep: new FormItemModel({ caption: '工作流步骤', detailType: 'FORMITEM', name: 'wfstep', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        hrtransferapplyid: new FormItemModel({ caption: '调动申请标识', detailType: 'FORMITEM', name: 'hrtransferapplyid', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

    };
}