import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, MainControlBase } from '@/studio-core';
import HRTransferApplyService from '@/service/hrtransfer-apply/hrtransfer-apply-service';
import DashboardViewdashboard_sysportlet1Service from './dashboard-viewdashboard-sysportlet1-portlet-service';
import HRTransferApplyUIService from '@/uiservice/hrtransfer-apply/hrtransfer-apply-ui-service';
import { Environment } from '@/environments/environment';


/**
 * dashboard_sysportlet1部件基类
 *
 * @export
 * @class MainControlBase
 * @extends {DashboardViewdashboard_sysportlet1PortletBase}
 */
export class DashboardViewdashboard_sysportlet1PortletBase extends MainControlBase {

    /**
     * 获取部件类型
     *
     * @protected
     * @type {string}
     * @memberof DashboardViewdashboard_sysportlet1PortletBase
     */
    protected controlType: string = 'PORTLET';

    /**
     * 建构部件服务对象
     *
     * @type {DashboardViewdashboard_sysportlet1Service}
     * @memberof DashboardViewdashboard_sysportlet1PortletBase
     */
    public service: DashboardViewdashboard_sysportlet1Service = new DashboardViewdashboard_sysportlet1Service({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {HRTransferApplyService}
     * @memberof DashboardViewdashboard_sysportlet1PortletBase
     */
    public appEntityService: HRTransferApplyService = new HRTransferApplyService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof DashboardViewdashboard_sysportlet1PortletBase
     */
    protected appDeName: string = 'hrtransferapply';

    /**
     * 应用实体中文名称
     *
     * @protected
     * @type {string}
     * @memberof DashboardViewdashboard_sysportlet1PortletBase
     */
    protected appDeLogicName: string = '调动申请';

    /**
     * 长度
     *
     * @type {number}
     * @memberof DashboardViewdashboard_sysportlet1
     */
    @Prop() public height?: number;

    /**
     * 宽度
     *
     * @type {number}
     * @memberof DashboardViewdashboard_sysportlet1
     */
    @Prop() public width?: number;



    /**
     * 是否自适应大小
     *
     * @returns {boolean}
     * @memberof DashboardViewdashboard_sysportlet1Base
     */
    @Prop({default: false})public isAdaptiveSize!: boolean;

    /**
     * 获取多项数据
     *
     * @returns {any[]}
     * @memberof DashboardViewdashboard_sysportlet1Base
     */
    public getDatas(): any[] {
        return [];
    }

    /**
     * 获取单项树
     *
     * @returns {*}
     * @memberof DashboardViewdashboard_sysportlet1Base
     */
    public getData(): any {
        return {};
    }

    /**
     * 获取高度
     *
     * @returns {any[]}
     * @memberof DashboardViewdashboard_sysportlet1Base
     */
    get getHeight(): any{
        if(!this.$util.isEmpty(this.height) && !this.$util.isNumberNaN(this.height)){
            if(this.height == 0){
                return 'auto';
            } else {
                return this.height+'px';
            }
        } else {
            return 'auto';
        }
    }

    /**
     * vue 生命周期
     *
     * @memberof DashboardViewdashboard_sysportlet1Base
     */
    public created() {
        this.afterCreated();
    }

    /**
     * 执行created后的逻辑
     *
     *  @memberof DashboardViewdashboard_sysportlet1Base
     */    
    public afterCreated(){
        if (this.viewState) {
            this.viewStateEvent = this.viewState.subscribe(({ tag, action, data }) => {
                if (!Object.is(tag, this.name)) {
                    return;
                }
                const refs: any = this.$refs;
                Object.keys(refs).forEach((_name: string) => {
                    this.viewState.next({ tag: _name, action: action, data: data });
                });
            });
        }
    }

    /**
     * vue 生命周期
     *
     * @memberof DashboardViewdashboard_sysportlet1Base
     */
    public destroyed() {
        this.afterDestroy();
    }

    /**
     * 执行destroyed后的逻辑
     *
     * @memberof DashboardViewdashboard_sysportlet1Base
     */
    public afterDestroy() {
        if (this.viewStateEvent) {
            this.viewStateEvent.unsubscribe();
        }
    }


}
