import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, EditFormControlBase } from '@/studio-core';
import HRCertificateService from '@/service/hrcertificate/hrcertificate-service';
import MainService from './main-form-service';
import HRCertificateUIService from '@/uiservice/hrcertificate/hrcertificate-ui-service';
import { FormButtonModel, FormPageModel, FormItemModel, FormDRUIPartModel, FormPartModel, FormGroupPanelModel, FormIFrameModel, FormRowItemModel, FormTabPageModel, FormTabPanelModel, FormUserControlModel } from '@/model/form-detail';


/**
 * form部件基类
 *
 * @export
 * @class EditFormControlBase
 * @extends {MainEditFormBase}
 */
export class MainEditFormBase extends EditFormControlBase {

    /**
     * 获取部件类型
     *
     * @protected
     * @type {string}
     * @memberof MainEditFormBase
     */
    protected controlType: string = 'FORM';

    /**
     * 建构部件服务对象
     *
     * @type {MainService}
     * @memberof MainEditFormBase
     */
    public service: MainService = new MainService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {HRCertificateService}
     * @memberof MainEditFormBase
     */
    public appEntityService: HRCertificateService = new HRCertificateService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof MainEditFormBase
     */
    protected appDeName: string = 'hrcertificate';

    /**
     * 应用实体中文名称
     *
     * @protected
     * @type {string}
     * @memberof MainEditFormBase
     */
    protected appDeLogicName: string = '证书信息';
    /**
     * 界面UI服务对象
     *
     * @type {HRCertificateUIService}
     * @memberof MainEditFormBase
     */  
    public appUIService:HRCertificateUIService = new HRCertificateUIService(this.$store);


    /**
     * 表单数据对象
     *
     * @type {*}
     * @memberof MainEditFormBase
     */
    public data: any = {
        srfupdatedate: null,
        srforikey: null,
        srfkey: null,
        srfmajortext: null,
        srftempmode: null,
        srfuf: null,
        srfdeid: null,
        srfsourcekey: null,
        hremployeename: null,
        certificatecode: null,
        hrcertificatename: null,
        authorganization: null,
        registerorganizationname: null,
        registercode: null,
        authdate: null,
        registertime: null,
        expiredate: null,
        activeflag: null,
        memo: null,
        attachment: null,
        hremployeeid: null,
        registerorganizationid: null,
        hrcertificateid: null,
        hrcertificate:null,
    };

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof MainEditFormBase
     */
    public rules: any = {
        hremployeename: [
            { required: true, type: 'string', message: '员工姓名 值不能为空', trigger: 'change' },
            { required: true, type: 'string', message: '员工姓名 值不能为空', trigger: 'blur' },
        ],
        certificatecode: [
            { required: true, type: 'string', message: '证书编号 值不能为空', trigger: 'change' },
            { required: true, type: 'string', message: '证书编号 值不能为空', trigger: 'blur' },
        ],
        hrcertificatename: [
            { required: true, type: 'string', message: '证书名称 值不能为空', trigger: 'change' },
            { required: true, type: 'string', message: '证书名称 值不能为空', trigger: 'blur' },
        ],
    }

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof MainBase
     */
    public deRules:any = {
    };

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof MainEditFormBase
     */
    public detailsModel: any = {
        group1: new FormGroupPanelModel({ caption: '证书信息', detailType: 'GROUPPANEL', name: 'group1', visible: true, isShowCaption: false, form: this, showMoreMode: 0, uiActionGroup: { caption: '', langbase: 'entities.hrcertificate.main_form', extractMode: 'ITEM', details: [] } }),

        grouppanel1: new FormGroupPanelModel({ caption: '证书获得情况', detailType: 'GROUPPANEL', name: 'grouppanel1', visible: true, isShowCaption: false, form: this, showMoreMode: 0, uiActionGroup: { caption: '', langbase: 'entities.hrcertificate.main_form', extractMode: 'ITEM', details: [] } }),

        formpage1: new FormPageModel({ caption: '基本信息', detailType: 'FORMPAGE', name: 'formpage1', visible: true, isShowCaption: true, form: this, showMoreMode: 0 }),

        srfupdatedate: new FormItemModel({ caption: '更新时间', detailType: 'FORMITEM', name: 'srfupdatedate', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srforikey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srforikey', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfkey: new FormItemModel({ caption: '证书信息标识', detailType: 'FORMITEM', name: 'srfkey', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfmajortext: new FormItemModel({ caption: '证书名称', detailType: 'FORMITEM', name: 'srfmajortext', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srftempmode: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srftempmode', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfuf: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfuf', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfdeid: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfdeid', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfsourcekey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfsourcekey', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        hremployeename: new FormItemModel({ caption: '员工姓名', detailType: 'FORMITEM', name: 'hremployeename', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        certificatecode: new FormItemModel({ caption: '证书编号', detailType: 'FORMITEM', name: 'certificatecode', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        hrcertificatename: new FormItemModel({ caption: '证书名称', detailType: 'FORMITEM', name: 'hrcertificatename', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        authorganization: new FormItemModel({ caption: '签发机构', detailType: 'FORMITEM', name: 'authorganization', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        registerorganizationname: new FormItemModel({ caption: '注册单位', detailType: 'FORMITEM', name: 'registerorganizationname', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        registercode: new FormItemModel({ caption: '注册编号', detailType: 'FORMITEM', name: 'registercode', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        authdate: new FormItemModel({ caption: '签发日期', detailType: 'FORMITEM', name: 'authdate', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        registertime: new FormItemModel({ caption: '初始注册时间', detailType: 'FORMITEM', name: 'registertime', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        expiredate: new FormItemModel({ caption: '失效日期', detailType: 'FORMITEM', name: 'expiredate', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        activeflag: new FormItemModel({ caption: '是否有效', detailType: 'FORMITEM', name: 'activeflag', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        memo: new FormItemModel({ caption: '备注', detailType: 'FORMITEM', name: 'memo', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        attachment: new FormItemModel({ caption: '附件', detailType: 'FORMITEM', name: 'attachment', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        hremployeeid: new FormItemModel({ caption: '员工标识', detailType: 'FORMITEM', name: 'hremployeeid', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        registerorganizationid: new FormItemModel({ caption: '注册单位ID', detailType: 'FORMITEM', name: 'registerorganizationid', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        hrcertificateid: new FormItemModel({ caption: '证书信息标识', detailType: 'FORMITEM', name: 'hrcertificateid', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

    };

    /**
     * 新建默认值
     * @memberof MainEditFormBase
     */
    public createDefault(){                    
        if (this.data.hasOwnProperty('activeflag')) {
            this.data['activeflag'] = 1;
        }
    }

    /**
     * 更新默认值
     * @memberof MainEditFormBase
     */
    public updateDefault(){                    
        if (this.data.hasOwnProperty('activeflag') && !this.data.activeflag) {
            this.data['activeflag'] = 1;
        }
    }
}