/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'organizationname',
          prop: 'organizationname',
          dataType: 'PICKUPDATA',
        },
        {
          name: 'empstate',
          prop: 'empstate',
          dataType: 'PICKUPDATA',
        },
        {
          name: 'archivesroom',
          prop: 'archivesroom',
          dataType: 'TEXT',
        },
        {
          name: 'archivescode',
          prop: 'archivescode',
          dataType: 'TEXT',
        },
        {
          name: 'employeecode',
          prop: 'employeecode',
          dataType: 'PICKUPDATA',
        },
        {
          name: 'srfmajortext',
          prop: 'hrarchivesname',
          dataType: 'TEXT',
        },
        {
          name: 'srfkey',
          prop: 'hrarchivesid',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'srfdataaccaction',
          prop: 'hrarchivesid',
          dataType: 'GUID',
        },
        {
          name: 'hremployeeid',
          prop: 'hremployeeid',
          dataType: 'PICKUP',
        },
        {
          name: 'borrowstate',
          prop: 'borrowstate',
          dataType: 'SSCODELIST',
        },
        {
          name: 'hrorganizationname',
          prop: 'hrorganizationname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'hremployeename',
          prop: 'hremployeename',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'archivesplace',
          prop: 'archivesplace',
          dataType: 'TEXT',
        },
        {
          name: 'hrorganizationid',
          prop: 'hrorganizationid',
          dataType: 'PICKUP',
        },
        {
          name: 'activeflag',
          prop: 'activeflag',
          dataType: 'YESNO',
        },
        {
          name: 'hrarchives',
          prop: 'hrarchivesid',
        },

        {
          name:'size',
          prop:'size'
        },
        {
          name:'query',
          prop:'query'
        },
        {
          name:'filter',
          prop:'filter'
        },
        {
          name:'page',
          prop:'page'
        },
        {
          name:'sort',
          prop:'sort'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}