import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, GridControlBase } from '@/studio-core';
import HRArchivesService from '@/service/hrarchives/hrarchives-service';
import MainService from './main-grid-service';
import HRArchivesUIService from '@/uiservice/hrarchives/hrarchives-ui-service';
import { FormItemModel } from '@/model/form-detail';


/**
 * grid部件基类
 *
 * @export
 * @class GridControlBase
 * @extends {MainGridBase}
 */
export class MainGridBase extends GridControlBase {

    /**
     * 获取部件类型
     *
     * @protected
     * @type {string}
     * @memberof MainGridBase
     */
    protected controlType: string = 'GRID';

    /**
     * 建构部件服务对象
     *
     * @type {MainService}
     * @memberof MainGridBase
     */
    public service: MainService = new MainService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {HRArchivesService}
     * @memberof MainGridBase
     */
    public appEntityService: HRArchivesService = new HRArchivesService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof MainGridBase
     */
    protected appDeName: string = 'hrarchives';

    /**
     * 应用实体中文名称
     *
     * @protected
     * @type {string}
     * @memberof MainGridBase
     */
    protected appDeLogicName: string = '档案信息';

    /**
     * 界面UI服务对象
     *
     * @type {HRArchivesUIService}
     * @memberof MainBase
     */  
    public appUIService:HRArchivesUIService = new HRArchivesUIService(this.$store);

    /**
     * 界面行为模型
     *
     * @type {*}
     * @memberof MainBase
     */  
    public ActionModel: any = {
    };

    /**
     * 本地缓存标识
     *
     * @protected
     * @type {string}
     * @memberof MainBase
     */
    protected localStorageTag: string = 'hrarchives_main_grid';

    /**
     * 所有列成员
     *
     * @type {any[]}
     * @memberof MainGridBase
     */
    public allColumns: any[] = [
        {
            name: 'archivescode',
            label: '档案编号',
            langtag: 'entities.hrarchives.main_grid.columns.archivescode',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'hrorganizationname',
            label: '档案管理单位',
            langtag: 'entities.hrarchives.main_grid.columns.hrorganizationname',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'archivesplace',
            label: '档案保管地',
            langtag: 'entities.hrarchives.main_grid.columns.archivesplace',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'archivesroom',
            label: '档案室',
            langtag: 'entities.hrarchives.main_grid.columns.archivesroom',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'activeflag',
            label: '是否有效',
            langtag: 'entities.hrarchives.main_grid.columns.activeflag',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'employeecode',
            label: '员工编号',
            langtag: 'entities.hrarchives.main_grid.columns.employeecode',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'hremployeename',
            label: '员工姓名',
            langtag: 'entities.hrarchives.main_grid.columns.hremployeename',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'empstate',
            label: '员工状态',
            langtag: 'entities.hrarchives.main_grid.columns.empstate',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'organizationname',
            label: '单位',
            langtag: 'entities.hrarchives.main_grid.columns.organizationname',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'borrowstate',
            label: '档案借阅状态',
            langtag: 'entities.hrarchives.main_grid.columns.borrowstate',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
    ]

    /**
     * 获取表格行模型
     *
     * @type {*}
     * @memberof MainGridBase
     */
    public getGridRowModel(){
        return {
          srfkey: new FormItemModel(),
        }
    }

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof MainGridBase
     */
    public rules: any = {
        srfkey: [
            { required: false, validator: (rule:any, value:any, callback:any) => { return (rule.required && (value === null || value === undefined || value === "")) ? false : true;}, message: '档案信息标识 值不能为空', trigger: 'change' },
            { required: false, validator: (rule:any, value:any, callback:any) => { return (rule.required && (value === null || value === undefined || value === "")) ? false : true;}, message: '档案信息标识 值不能为空', trigger: 'blur' },
        ],
    }

    /**
     * 获取对应列class
     *
     * @type {*}
     * @memberof MainBase
     */
    public hasRowEdit: any = {
        'archivescode':false,
        'hrorganizationname':false,
        'archivesplace':false,
        'archivesroom':false,
        'activeflag':false,
        'employeecode':false,
        'hremployeename':false,
        'empstate':false,
        'organizationname':false,
        'borrowstate':false,
    };

    /**
     * 获取对应列class
     *
     * @param {*} $args row 行数据，column 列数据，rowIndex 行索引，列索引
     * @returns {void}
     * @memberof MainBase
     */
    public getCellClassName(args: {row: any, column: any, rowIndex: number, columnIndex: number}): any {
        return ( this.hasRowEdit[args.column.property] && this.actualIsOpenEdit ) ? "edit-cell" : "info-cell";
    }


    /**
     * 导出数据格式化
     *
     * @param {*} filterVal
     * @param {*} jsonData
     * @param {any[]} [codelistColumns=[]]
     * @returns {Promise<any>}
     * @memberof MainGridBase
     */
    public async formatExcelData(filterVal: any, jsonData: any, codelistColumns?: any[]): Promise<any> {
        return super.formatExcelData(filterVal, jsonData, [
            {
                name: 'activeflag',
                srfkey: 'YesNo',
                codelistType : 'STATIC',
                renderMode: 'other',
                textSeparator: '、',
                valueSeparator: ',',
            },
            {
                name: 'empstate',
                srfkey: 'CL_HR_0016',
                codelistType : 'DYNAMIC',
                renderMode: 'other',
                textSeparator: '、',
                valueSeparator: ',',
            },
        ]);
    }

}