import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, GridControlBase } from '@/studio-core';
import HRArchivesBorrowService from '@/service/hrarchives-borrow/hrarchives-borrow-service';
import MainService from './main-grid-service';
import HRArchivesBorrowUIService from '@/uiservice/hrarchives-borrow/hrarchives-borrow-ui-service';
import { FormItemModel } from '@/model/form-detail';


/**
 * grid部件基类
 *
 * @export
 * @class GridControlBase
 * @extends {MainGridBase}
 */
export class MainGridBase extends GridControlBase {

    /**
     * 获取部件类型
     *
     * @protected
     * @type {string}
     * @memberof MainGridBase
     */
    protected controlType: string = 'GRID';

    /**
     * 建构部件服务对象
     *
     * @type {MainService}
     * @memberof MainGridBase
     */
    public service: MainService = new MainService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {HRArchivesBorrowService}
     * @memberof MainGridBase
     */
    public appEntityService: HRArchivesBorrowService = new HRArchivesBorrowService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof MainGridBase
     */
    protected appDeName: string = 'hrarchivesborrow';

    /**
     * 应用实体中文名称
     *
     * @protected
     * @type {string}
     * @memberof MainGridBase
     */
    protected appDeLogicName: string = '档案借阅';

    /**
     * 界面UI服务对象
     *
     * @type {HRArchivesBorrowUIService}
     * @memberof MainBase
     */  
    public appUIService:HRArchivesBorrowUIService = new HRArchivesBorrowUIService(this.$store);

    /**
     * 界面行为模型
     *
     * @type {*}
     * @memberof MainBase
     */  
    public ActionModel: any = {
    };

    /**
     * 本地缓存标识
     *
     * @protected
     * @type {string}
     * @memberof MainBase
     */
    protected localStorageTag: string = 'hrarchivesborrow_main_grid';

    /**
     * 是否支持分页
     *
     * @type {boolean}
     * @memberof MainGridBase
     */
    public isEnablePagingBar: boolean = false;

    /**
     * 所有列成员
     *
     * @type {any[]}
     * @memberof MainGridBase
     */
    public allColumns: any[] = [
        {
            name: 'borrowman',
            label: '借阅人',
            langtag: 'entities.hrarchivesborrow.main_grid.columns.borrowman',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'begintime',
            label: '借阅时间',
            langtag: 'entities.hrarchivesborrow.main_grid.columns.begintime',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'endtime',
            label: '归还时间',
            langtag: 'entities.hrarchivesborrow.main_grid.columns.endtime',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'checkman',
            label: '审批同意人',
            langtag: 'entities.hrarchivesborrow.main_grid.columns.checkman',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'checktime',
            label: '审批时间',
            langtag: 'entities.hrarchivesborrow.main_grid.columns.checktime',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'borrowreason',
            label: '借阅原因',
            langtag: 'entities.hrarchivesborrow.main_grid.columns.borrowreason',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'borrowstate',
            label: '借阅状态',
            langtag: 'entities.hrarchivesborrow.main_grid.columns.borrowstate',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
    ]

    /**
     * 获取表格行模型
     *
     * @type {*}
     * @memberof MainGridBase
     */
    public getGridRowModel(){
        return {
          srfkey: new FormItemModel(),
        }
    }

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof MainGridBase
     */
    public rules: any = {
        srfkey: [
            { required: false, validator: (rule:any, value:any, callback:any) => { return (rule.required && (value === null || value === undefined || value === "")) ? false : true;}, message: '档案借阅标识 值不能为空', trigger: 'change' },
            { required: false, validator: (rule:any, value:any, callback:any) => { return (rule.required && (value === null || value === undefined || value === "")) ? false : true;}, message: '档案借阅标识 值不能为空', trigger: 'blur' },
        ],
    }

    /**
     * 获取对应列class
     *
     * @type {*}
     * @memberof MainBase
     */
    public hasRowEdit: any = {
        'borrowman':false,
        'begintime':false,
        'endtime':false,
        'checkman':false,
        'checktime':false,
        'borrowreason':false,
        'borrowstate':false,
    };

    /**
     * 获取对应列class
     *
     * @param {*} $args row 行数据，column 列数据，rowIndex 行索引，列索引
     * @returns {void}
     * @memberof MainBase
     */
    public getCellClassName(args: {row: any, column: any, rowIndex: number, columnIndex: number}): any {
        return ( this.hasRowEdit[args.column.property] && this.actualIsOpenEdit ) ? "edit-cell" : "info-cell";
    }


    /**
     * 导出数据格式化
     *
     * @param {*} filterVal
     * @param {*} jsonData
     * @param {any[]} [codelistColumns=[]]
     * @returns {Promise<any>}
     * @memberof MainGridBase
     */
    public async formatExcelData(filterVal: any, jsonData: any, codelistColumns?: any[]): Promise<any> {
        return super.formatExcelData(filterVal, jsonData, [
            {
                name: 'borrowstate',
                srfkey: 'CL_HR_0024',
                codelistType : 'STATIC',
                renderMode: 'other',
                textSeparator: '、',
                valueSeparator: ',',
            },
        ]);
    }

}