import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, EditFormControlBase } from '@/studio-core';
import HRArchivesBorrowService from '@/service/hrarchives-borrow/hrarchives-borrow-service';
import MainService from './main-form-service';
import HRArchivesBorrowUIService from '@/uiservice/hrarchives-borrow/hrarchives-borrow-ui-service';
import { FormButtonModel, FormPageModel, FormItemModel, FormDRUIPartModel, FormPartModel, FormGroupPanelModel, FormIFrameModel, FormRowItemModel, FormTabPageModel, FormTabPanelModel, FormUserControlModel } from '@/model/form-detail';


/**
 * form部件基类
 *
 * @export
 * @class EditFormControlBase
 * @extends {MainEditFormBase}
 */
export class MainEditFormBase extends EditFormControlBase {

    /**
     * 获取部件类型
     *
     * @protected
     * @type {string}
     * @memberof MainEditFormBase
     */
    protected controlType: string = 'FORM';

    /**
     * 建构部件服务对象
     *
     * @type {MainService}
     * @memberof MainEditFormBase
     */
    public service: MainService = new MainService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {HRArchivesBorrowService}
     * @memberof MainEditFormBase
     */
    public appEntityService: HRArchivesBorrowService = new HRArchivesBorrowService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof MainEditFormBase
     */
    protected appDeName: string = 'hrarchivesborrow';

    /**
     * 应用实体中文名称
     *
     * @protected
     * @type {string}
     * @memberof MainEditFormBase
     */
    protected appDeLogicName: string = '档案借阅';
    /**
     * 界面UI服务对象
     *
     * @type {HRArchivesBorrowUIService}
     * @memberof MainEditFormBase
     */  
    public appUIService:HRArchivesBorrowUIService = new HRArchivesBorrowUIService(this.$store);


    /**
     * 表单数据对象
     *
     * @type {*}
     * @memberof MainEditFormBase
     */
    public data: any = {
        srfupdatedate: null,
        srforikey: null,
        srfkey: null,
        srfmajortext: null,
        srftempmode: null,
        srfuf: null,
        srfdeid: null,
        srfsourcekey: null,
        borrowman: null,
        begintime: null,
        endtime: null,
        checkman: null,
        checktime: null,
        borrowreason: null,
        borrowstate: null,
        hrarchivesborrowid: null,
        hrarchivesborrow:null,
    };

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof MainEditFormBase
     */
    public rules: any = {
        borrowman: [
            { required: true, type: 'string', message: '借阅人 值不能为空', trigger: 'change' },
            { required: true, type: 'string', message: '借阅人 值不能为空', trigger: 'blur' },
        ],
        begintime: [
            { required: true, type: 'string', message: '借阅时间 值不能为空', trigger: 'change' },
            { required: true, type: 'string', message: '借阅时间 值不能为空', trigger: 'blur' },
        ],
        borrowstate: [
            { required: true, type: 'string', message: '借阅状态 值不能为空', trigger: 'change' },
            { required: true, type: 'string', message: '借阅状态 值不能为空', trigger: 'blur' },
        ],
    }

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof MainBase
     */
    public deRules:any = {
    };

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof MainEditFormBase
     */
    public detailsModel: any = {
        group1: new FormGroupPanelModel({ caption: '档案借阅基本信息', detailType: 'GROUPPANEL', name: 'group1', visible: true, isShowCaption: false, form: this, showMoreMode: 0, uiActionGroup: { caption: '', langbase: 'entities.hrarchivesborrow.main_form', extractMode: 'ITEM', details: [] } }),

        formpage1: new FormPageModel({ caption: '基本信息', detailType: 'FORMPAGE', name: 'formpage1', visible: true, isShowCaption: true, form: this, showMoreMode: 0 }),

        srfupdatedate: new FormItemModel({ caption: '更新时间', detailType: 'FORMITEM', name: 'srfupdatedate', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srforikey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srforikey', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfkey: new FormItemModel({ caption: '档案借阅标识', detailType: 'FORMITEM', name: 'srfkey', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfmajortext: new FormItemModel({ caption: '档案借阅名称', detailType: 'FORMITEM', name: 'srfmajortext', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srftempmode: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srftempmode', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfuf: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfuf', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfdeid: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfdeid', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfsourcekey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfsourcekey', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        borrowman: new FormItemModel({ caption: '借阅人', detailType: 'FORMITEM', name: 'borrowman', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        begintime: new FormItemModel({ caption: '借阅时间', detailType: 'FORMITEM', name: 'begintime', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        endtime: new FormItemModel({ caption: '归还时间', detailType: 'FORMITEM', name: 'endtime', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        checkman: new FormItemModel({ caption: '审批同意人', detailType: 'FORMITEM', name: 'checkman', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        checktime: new FormItemModel({ caption: '审批时间', detailType: 'FORMITEM', name: 'checktime', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        borrowreason: new FormItemModel({ caption: '借阅原因', detailType: 'FORMITEM', name: 'borrowreason', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        borrowstate: new FormItemModel({ caption: '借阅状态', detailType: 'FORMITEM', name: 'borrowstate', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        hrarchivesborrowid: new FormItemModel({ caption: '档案借阅标识', detailType: 'FORMITEM', name: 'hrarchivesborrowid', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

    };
}