/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'hromhierarchycatid',
          prop: 'hromhierarchycatid',
          dataType: 'PICKUP',
        },
        {
          name: 'pomhierarchyid',
          prop: 'pomhierarchyid',
          dataType: 'PICKUP',
          isEditable:true
        },
        {
          name: 'organizationname',
          prop: 'organizationname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'organizationid',
          prop: 'organizationid',
          dataType: 'PICKUP',
        },
        {
          name: 'pomhierarchyname',
          prop: 'pomhierarchyname',
          dataType: 'PICKUPTEXT',
          isEditable:true
        },
        {
          name: 'showorder',
          prop: 'showorder',
          dataType: 'BIGINT',
          isEditable:true
        },
        {
          name: 'srfmajortext',
          prop: 'organizationname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'omhierarchyid',
          dataType: 'GUID',
        },
        {
          name: 'srfkey',
          prop: 'omhierarchyid',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'hromhierarchy',
          prop: 'omhierarchyid',
        },

        {
          name:'size',
          prop:'size'
        },
        {
          name:'query',
          prop:'query'
        },
        {
          name:'filter',
          prop:'filter'
        },
        {
          name:'page',
          prop:'page'
        },
        {
          name:'sort',
          prop:'sort'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}