/**
 * GRID_001 部件模型
 *
 * @export
 * @class GRID_001Model
 */
export default class GRID_001Model {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof GRID_001GridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof GRID_001GridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'registerorganizationname',
          prop: 'registerorganizationname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'registertime',
          prop: 'registertime',
          dataType: 'DATE',
        },
        {
          name: 'authdate',
          prop: 'authdate',
          dataType: 'DATE',
        },
        {
          name: 'expiredate',
          prop: 'expiredate',
          dataType: 'DATE',
        },
        {
          name: 'srfmajortext',
          prop: 'hrcertificatename',
          dataType: 'TEXT',
        },
        {
          name: 'srfkey',
          prop: 'hrcertificateid',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'srfdataaccaction',
          prop: 'hrcertificateid',
          dataType: 'GUID',
        },
        {
          name: 'hrcertificatename',
          prop: 'hrcertificatename',
          dataType: 'TEXT',
        },
        {
          name: 'certificatecode',
          prop: 'certificatecode',
          dataType: 'TEXT',
        },
        {
          name: 'hremployeeid',
          prop: 'hremployeeid',
          dataType: 'PICKUP',
        },
        {
          name: 'registerorganizationid',
          prop: 'registerorganizationid',
          dataType: 'PICKUP',
        },
        {
          name: 'registercode',
          prop: 'registercode',
          dataType: 'TEXT',
        },
        {
          name: 'authorganization',
          prop: 'authorganization',
          dataType: 'TEXT',
        },
        {
          name: 'hrcertificate',
          prop: 'hrcertificateid',
        },

        {
          name:'size',
          prop:'size'
        },
        {
          name:'query',
          prop:'query'
        },
        {
          name:'filter',
          prop:'filter'
        },
        {
          name:'page',
          prop:'page'
        },
        {
          name:'sort',
          prop:'sort'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}