import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, GridControlBase } from '@/studio-core';
import HRCertificateService from '@/service/hrcertificate/hrcertificate-service';
import GRID_001Service from './grid-001-grid-service';
import HRCertificateUIService from '@/uiservice/hrcertificate/hrcertificate-ui-service';
import { FormItemModel } from '@/model/form-detail';


/**
 * grid部件基类
 *
 * @export
 * @class GridControlBase
 * @extends {GRID_001GridBase}
 */
export class GRID_001GridBase extends GridControlBase {

    /**
     * 获取部件类型
     *
     * @protected
     * @type {string}
     * @memberof GRID_001GridBase
     */
    protected controlType: string = 'GRID';

    /**
     * 建构部件服务对象
     *
     * @type {GRID_001Service}
     * @memberof GRID_001GridBase
     */
    public service: GRID_001Service = new GRID_001Service({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {HRCertificateService}
     * @memberof GRID_001GridBase
     */
    public appEntityService: HRCertificateService = new HRCertificateService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof GRID_001GridBase
     */
    protected appDeName: string = 'hrcertificate';

    /**
     * 应用实体中文名称
     *
     * @protected
     * @type {string}
     * @memberof GRID_001GridBase
     */
    protected appDeLogicName: string = '证书信息';

    /**
     * 界面UI服务对象
     *
     * @type {HRCertificateUIService}
     * @memberof GRID_001Base
     */  
    public appUIService:HRCertificateUIService = new HRCertificateUIService(this.$store);

    /**
     * 界面行为模型
     *
     * @type {*}
     * @memberof GRID_001Base
     */  
    public ActionModel: any = {
    };

    /**
     * 本地缓存标识
     *
     * @protected
     * @type {string}
     * @memberof GRID_001Base
     */
    protected localStorageTag: string = 'hrcertificate_grid_001_grid';

    /**
     * 所有列成员
     *
     * @type {any[]}
     * @memberof GRID_001GridBase
     */
    public allColumns: any[] = [
        {
            name: 'hrcertificatename',
            label: '证书名称',
            langtag: 'entities.hrcertificate.grid_001_grid.columns.hrcertificatename',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'certificatecode',
            label: '证书编号',
            langtag: 'entities.hrcertificate.grid_001_grid.columns.certificatecode',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'authdate',
            label: '签发日期',
            langtag: 'entities.hrcertificate.grid_001_grid.columns.authdate',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'expiredate',
            label: '失效日期',
            langtag: 'entities.hrcertificate.grid_001_grid.columns.expiredate',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'authorganization',
            label: '签发机构',
            langtag: 'entities.hrcertificate.grid_001_grid.columns.authorganization',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'registercode',
            label: '注册编号',
            langtag: 'entities.hrcertificate.grid_001_grid.columns.registercode',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'registerorganizationname',
            label: '注册单位',
            langtag: 'entities.hrcertificate.grid_001_grid.columns.registerorganizationname',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'registertime',
            label: '初始注册时间',
            langtag: 'entities.hrcertificate.grid_001_grid.columns.registertime',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
    ]

    /**
     * 获取表格行模型
     *
     * @type {*}
     * @memberof GRID_001GridBase
     */
    public getGridRowModel(){
        return {
          srfkey: new FormItemModel(),
        }
    }

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof GRID_001GridBase
     */
    public rules: any = {
        srfkey: [
            { required: false, validator: (rule:any, value:any, callback:any) => { return (rule.required && (value === null || value === undefined || value === "")) ? false : true;}, message: '证书信息标识 值不能为空', trigger: 'change' },
            { required: false, validator: (rule:any, value:any, callback:any) => { return (rule.required && (value === null || value === undefined || value === "")) ? false : true;}, message: '证书信息标识 值不能为空', trigger: 'blur' },
        ],
    }

    /**
     * 获取对应列class
     *
     * @type {*}
     * @memberof GRID_001Base
     */
    public hasRowEdit: any = {
        'hrcertificatename':false,
        'certificatecode':false,
        'authdate':false,
        'expiredate':false,
        'authorganization':false,
        'registercode':false,
        'registerorganizationname':false,
        'registertime':false,
    };

    /**
     * 获取对应列class
     *
     * @param {*} $args row 行数据，column 列数据，rowIndex 行索引，列索引
     * @returns {void}
     * @memberof GRID_001Base
     */
    public getCellClassName(args: {row: any, column: any, rowIndex: number, columnIndex: number}): any {
        return ( this.hasRowEdit[args.column.property] && this.actualIsOpenEdit ) ? "edit-cell" : "info-cell";
    }


    /**
     * 导出数据格式化
     *
     * @param {*} filterVal
     * @param {*} jsonData
     * @param {any[]} [codelistColumns=[]]
     * @returns {Promise<any>}
     * @memberof GRID_001GridBase
     */
    public async formatExcelData(filterVal: any, jsonData: any, codelistColumns?: any[]): Promise<any> {
        return super.formatExcelData(filterVal, jsonData, [
        ]);
    }

}