import AuthService from '../auth-service';

/**
 * 组织层次结构分配权限服务对象基类
 *
 * @export
 * @class HROMHierarchyPurposeRefAuthServiceBase
 * @extends {AuthService}
 */
export default class HROMHierarchyPurposeRefAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  HROMHierarchyPurposeRefAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  HROMHierarchyPurposeRefAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof HROMHierarchyPurposeRefAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}