/**
 * UI服务注册中心
 *
 * @export
 * @class UIServiceRegister
 */
export class UIServiceRegister {

    /**
     * 所有UI实体服务Map
     *
     * @protected
     * @type {*}
     * @memberof UIServiceRegister
     */
    protected allUIService: Map<string, () => Promise<any>> = new Map();

    /**
     * 已加载UI实体服务Map缓存
     *
     * @protected
     * @type {Map<string, any>}
     * @memberof UIServiceRegister
     */
    protected serviceCache: Map<string, any> = new Map();

    /**
     * Creates an instance of UIServiceRegister.
     * @memberof UIServiceRegister
     */
    constructor() {
        this.init();
    }

    /**
     * 初始化
     *
     * @protected
     * @memberof UIServiceRegister
     */
    protected init(): void {
                this.allUIService.set('hroperationunit', () => import('@/uiservice/hroperation-unit/hroperation-unit-ui-service'));
        this.allUIService.set('hrfamily', () => import('@/uiservice/hrfamily/hrfamily-ui-service'));
        this.allUIService.set('hrreward', () => import('@/uiservice/hrreward/hrreward-ui-service'));
        this.allUIService.set('hromhierarchypurposeref', () => import('@/uiservice/hromhierarchy-purpose-ref/hromhierarchy-purpose-ref-ui-service'));
        this.allUIService.set('hromhierarchycat', () => import('@/uiservice/hromhierarchy-cat/hromhierarchy-cat-ui-service'));
        this.allUIService.set('hrcertificate', () => import('@/uiservice/hrcertificate/hrcertificate-ui-service'));
        this.allUIService.set('hrorgcontact', () => import('@/uiservice/hrorg-contact/hrorg-contact-ui-service'));
        this.allUIService.set('hrempstate', () => import('@/uiservice/hremp-state/hremp-state-ui-service'));
        this.allUIService.set('hrtransferapply', () => import('@/uiservice/hrtransfer-apply/hrtransfer-apply-ui-service'));
        this.allUIService.set('hrtechnicaltitle', () => import('@/uiservice/hrtechnical-title/hrtechnical-title-ui-service'));
        this.allUIService.set('hremployee', () => import('@/uiservice/hremployee/hremployee-ui-service'));
        this.allUIService.set('hrlegal', () => import('@/uiservice/hrlegal/hrlegal-ui-service'));
        this.allUIService.set('hrdutyedu', () => import('@/uiservice/hrduty-edu/hrduty-edu-ui-service'));
        this.allUIService.set('hrlanguageability', () => import('@/uiservice/hrlanguage-ability/hrlanguage-ability-ui-service'));
        this.allUIService.set('hromhierarchypurpose', () => import('@/uiservice/hromhierarchypurpose/hromhierarchypurpose-ui-service'));
        this.allUIService.set('hromhierarchy', () => import('@/uiservice/hromhierarchy/hromhierarchy-ui-service'));
        this.allUIService.set('hrworkrecord', () => import('@/uiservice/hrwork-record/hrwork-record-ui-service'));
        this.allUIService.set('hrdistribution', () => import('@/uiservice/hrdistribution/hrdistribution-ui-service'));
        this.allUIService.set('hrorgaddress', () => import('@/uiservice/hrorg-address/hrorg-address-ui-service'));
        this.allUIService.set('hrpost', () => import('@/uiservice/hrpost/hrpost-ui-service'));
        this.allUIService.set('hrcontract', () => import('@/uiservice/hrcontract/hrcontract-ui-service'));
        this.allUIService.set('hrpatent', () => import('@/uiservice/hrpatent/hrpatent-ui-service'));
        this.allUIService.set('hrorganization', () => import('@/uiservice/hrorganization/hrorganization-ui-service'));
        this.allUIService.set('hrdutyskill', () => import('@/uiservice/hrduty-skill/hrduty-skill-ui-service'));
        this.allUIService.set('hrdutycert', () => import('@/uiservice/hrduty-cert/hrduty-cert-ui-service'));
        this.allUIService.set('hreducation', () => import('@/uiservice/hreducation/hreducation-ui-service'));
        this.allUIService.set('hrduty', () => import('@/uiservice/hrduty/hrduty-ui-service'));
        this.allUIService.set('hrresearch', () => import('@/uiservice/hrresearch/hrresearch-ui-service'));
        this.allUIService.set('hrpostrel', () => import('@/uiservice/hrpost-rel/hrpost-rel-ui-service'));
        this.allUIService.set('hrtrainingrecord', () => import('@/uiservice/hrtraining-record/hrtraining-record-ui-service'));
        this.allUIService.set('hrpaper', () => import('@/uiservice/hrpaper/hrpaper-ui-service'));
        this.allUIService.set('hrarchives', () => import('@/uiservice/hrarchives/hrarchives-ui-service'));
    }

    /**
     * 加载服务实体
     *
     * @protected
     * @param {string} serviceName
     * @returns {Promise<any>}
     * @memberof UIServiceRegister
     */
    protected async loadService(serviceName: string): Promise<any> {
        const service = this.allUIService.get(serviceName);
        if (service) {
            return service();
        }
    }

    /**
     * 获取应用实体服务
     *
     * @param {string} name
     * @returns {Promise<any>}
     * @memberof UIServiceRegister
     */
    public async getService(name: string): Promise<any> {
        if (this.serviceCache.has(name)) {
            return this.serviceCache.get(name);
        }
        const entityService: any = await this.loadService(name);
        if (entityService && entityService.default) {
            const instance: any = new entityService.default();
            this.serviceCache.set(name, instance);
            return instance;
        }
    }

}
export const uiServiceRegister: UIServiceRegister = new UIServiceRegister();