/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'memo',
          prop: 'memo',
          dataType: 'LONGTEXT_1000',
        },
        {
          name: 'moveinorg',
          prop: 'moveinorg',
          dataType: 'TEXT',
        },
        {
          name: 'movetype',
          prop: 'movetype',
          dataType: 'SSCODELIST',
        },
        {
          name: 'moveoutorg',
          prop: 'moveoutorg',
          dataType: 'TEXT',
        },
        {
          name: 'activetime',
          prop: 'activetime',
          dataType: 'DATE',
        },
        {
          name: 'hrarchivesid',
          prop: 'hrarchivesid',
          dataType: 'PICKUP',
        },
        {
          name: 'srfmajortext',
          prop: 'hrarchivesmovename',
          dataType: 'TEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'hrarchivesmoveid',
          dataType: 'GUID',
        },
        {
          name: 'srfkey',
          prop: 'hrarchivesmoveid',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'hrarchivesmove',
          prop: 'hrarchivesmoveid',
        },

        {
          name:'size',
          prop:'size'
        },
        {
          name:'query',
          prop:'query'
        },
        {
          name:'filter',
          prop:'filter'
        },
        {
          name:'page',
          prop:'page'
        },
        {
          name:'sort',
          prop:'sort'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}