import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, EditFormControlBase } from '@/studio-core';
import HRArchivesService from '@/service/hrarchives/hrarchives-service';
import MainService from './main-form-service';
import HRArchivesUIService from '@/uiservice/hrarchives/hrarchives-ui-service';
import { FormButtonModel, FormPageModel, FormItemModel, FormDRUIPartModel, FormPartModel, FormGroupPanelModel, FormIFrameModel, FormRowItemModel, FormTabPageModel, FormTabPanelModel, FormUserControlModel } from '@/model/form-detail';


/**
 * form部件基类
 *
 * @export
 * @class EditFormControlBase
 * @extends {MainEditFormBase}
 */
export class MainEditFormBase extends EditFormControlBase {

    /**
     * 获取部件类型
     *
     * @protected
     * @type {string}
     * @memberof MainEditFormBase
     */
    protected controlType: string = 'FORM';

    /**
     * 建构部件服务对象
     *
     * @type {MainService}
     * @memberof MainEditFormBase
     */
    public service: MainService = new MainService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {HRArchivesService}
     * @memberof MainEditFormBase
     */
    public appEntityService: HRArchivesService = new HRArchivesService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof MainEditFormBase
     */
    protected appDeName: string = 'hrarchives';

    /**
     * 应用实体中文名称
     *
     * @protected
     * @type {string}
     * @memberof MainEditFormBase
     */
    protected appDeLogicName: string = '档案信息';
    /**
     * 界面UI服务对象
     *
     * @type {HRArchivesUIService}
     * @memberof MainEditFormBase
     */  
    public appUIService:HRArchivesUIService = new HRArchivesUIService(this.$store);


    /**
     * 表单数据对象
     *
     * @type {*}
     * @memberof MainEditFormBase
     */
    public data: any = {
        srfupdatedate: null,
        srforikey: null,
        srfkey: null,
        srfmajortext: null,
        srftempmode: null,
        srfuf: null,
        srfdeid: null,
        srfsourcekey: null,
        archivescode: null,
        hrorganizationname: null,
        archivesplace: null,
        archivesroom: null,
        hremployeename: null,
        employeecode: null,
        organizationname: null,
        activeflag: null,
        degree: null,
        birthday: null,
        startworktime: null,
        politicaltime: null,
        memo: null,
        hremployeeid: null,
        hrorganizationid: null,
        hrarchivesid: null,
        hrarchives:null,
    };

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof MainEditFormBase
     */
    public rules: any = {
        archivescode: [
            { required: true, type: 'string', message: '档案编号 值不能为空', trigger: 'change' },
            { required: true, type: 'string', message: '档案编号 值不能为空', trigger: 'blur' },
        ],
        hrorganizationname: [
            { required: true, type: 'string', message: '档案管理单位 值不能为空', trigger: 'change' },
            { required: true, type: 'string', message: '档案管理单位 值不能为空', trigger: 'blur' },
        ],
        hremployeename: [
            { required: true, type: 'string', message: '员工姓名 值不能为空', trigger: 'change' },
            { required: true, type: 'string', message: '员工姓名 值不能为空', trigger: 'blur' },
        ],
        activeflag: [
            { required: true, type: 'number', message: '是否有效 值不能为空', trigger: 'change' },
            { required: true, type: 'number', message: '是否有效 值不能为空', trigger: 'blur' },
        ],
    }

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof MainBase
     */
    public deRules:any = {
    };

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof MainEditFormBase
     */
    public detailsModel: any = {
        group1: new FormGroupPanelModel({ caption: '档案信息', detailType: 'GROUPPANEL', name: 'group1', visible: true, isShowCaption: true, form: this, showMoreMode: 0, uiActionGroup: { caption: '', langbase: 'entities.hrarchives.main_form', extractMode: 'ITEM', details: [] } }),

        formpage1: new FormPageModel({ caption: '基本信息', detailType: 'FORMPAGE', name: 'formpage1', visible: true, isShowCaption: true, form: this, showMoreMode: 0 }),

        srfupdatedate: new FormItemModel({ caption: '更新时间', detailType: 'FORMITEM', name: 'srfupdatedate', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srforikey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srforikey', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfkey: new FormItemModel({ caption: '档案信息标识', detailType: 'FORMITEM', name: 'srfkey', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfmajortext: new FormItemModel({ caption: '档案信息名称', detailType: 'FORMITEM', name: 'srfmajortext', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srftempmode: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srftempmode', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfuf: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfuf', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfdeid: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfdeid', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfsourcekey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfsourcekey', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        archivescode: new FormItemModel({ caption: '档案编号', detailType: 'FORMITEM', name: 'archivescode', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        hrorganizationname: new FormItemModel({ caption: '档案管理单位', detailType: 'FORMITEM', name: 'hrorganizationname', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        archivesplace: new FormItemModel({ caption: '档案保管地', detailType: 'FORMITEM', name: 'archivesplace', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        archivesroom: new FormItemModel({ caption: '档案室', detailType: 'FORMITEM', name: 'archivesroom', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        hremployeename: new FormItemModel({ caption: '员工姓名', detailType: 'FORMITEM', name: 'hremployeename', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        employeecode: new FormItemModel({ caption: '员工编号', detailType: 'FORMITEM', name: 'employeecode', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        organizationname: new FormItemModel({ caption: '单位', detailType: 'FORMITEM', name: 'organizationname', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        activeflag: new FormItemModel({ caption: '是否有效', detailType: 'FORMITEM', name: 'activeflag', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        degree: new FormItemModel({ caption: '档案学历', detailType: 'FORMITEM', name: 'degree', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        birthday: new FormItemModel({ caption: '档案出生日期', detailType: 'FORMITEM', name: 'birthday', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        startworktime: new FormItemModel({ caption: '档案参加工作时间', detailType: 'FORMITEM', name: 'startworktime', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        politicaltime: new FormItemModel({ caption: '档案入党时间', detailType: 'FORMITEM', name: 'politicaltime', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        memo: new FormItemModel({ caption: '备注', detailType: 'FORMITEM', name: 'memo', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        hremployeeid: new FormItemModel({ caption: '员工标识', detailType: 'FORMITEM', name: 'hremployeeid', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        hrorganizationid: new FormItemModel({ caption: '档案管理单位ID', detailType: 'FORMITEM', name: 'hrorganizationid', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        hrarchivesid: new FormItemModel({ caption: '档案信息标识', detailType: 'FORMITEM', name: 'hrarchivesid', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

    };

    /**
     * 新建默认值
     * @memberof MainEditFormBase
     */
    public createDefault(){                    
        if (this.data.hasOwnProperty('activeflag')) {
            this.data['activeflag'] = 1;
        }
    }

    /**
     * 更新默认值
     * @memberof MainEditFormBase
     */
    public updateDefault(){                    
        if (this.data.hasOwnProperty('activeflag') && !this.data.activeflag) {
            this.data['activeflag'] = 1;
        }
    }
}