/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'endtime',
          prop: 'endtime',
          dataType: 'DATE',
        },
        {
          name: 'hrpostid',
          prop: 'hrpostid',
          dataType: 'PICKUP',
        },
        {
          name: 'hremployeeid',
          prop: 'hremployeeid',
          dataType: 'PICKUP',
        },
        {
          name: 'hrorganizationname',
          prop: 'hrorganizationname',
          dataType: 'PICKUPDATA',
        },
        {
          name: 'hremployeename',
          prop: 'hremployeename',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'hrpostname',
          prop: 'hrpostname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'hrdutyname',
          prop: 'hrdutyname',
          dataType: 'PICKUPDATA',
        },
        {
          name: 'begintime',
          prop: 'begintime',
          dataType: 'DATE',
        },
        {
          name: 'srfmajortext',
          prop: 'hrdistributionname',
          dataType: 'TEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'hrdistributionid',
          dataType: 'GUID',
        },
        {
          name: 'srfkey',
          prop: 'hrdistributionid',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'hrdistribution',
          prop: 'hrdistributionid',
        },
        {
          name:'size',
          prop:'size'
        },
        {
          name:'query',
          prop:'query'
        },
        {
          name:'filter',
          prop:'filter'
        },
        {
          name:'page',
          prop:'page'
        },
        {
          name:'sort',
          prop:'sort'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}