import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, GridControlBase } from '@/studio-core';
import HRContractService from '@/service/hrcontract/hrcontract-service';
import MainService from './main-grid-service';
import HRContractUIService from '@/uiservice/hrcontract/hrcontract-ui-service';
import { FormItemModel } from '@/model/form-detail';


/**
 * grid部件基类
 *
 * @export
 * @class GridControlBase
 * @extends {MainGridBase}
 */
export class MainGridBase extends GridControlBase {

    /**
     * 获取部件类型
     *
     * @protected
     * @type {string}
     * @memberof MainGridBase
     */
    protected controlType: string = 'GRID';

    /**
     * 建构部件服务对象
     *
     * @type {MainService}
     * @memberof MainGridBase
     */
    public service: MainService = new MainService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {HRContractService}
     * @memberof MainGridBase
     */
    public appEntityService: HRContractService = new HRContractService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof MainGridBase
     */
    protected appDeName: string = 'hrcontract';

    /**
     * 应用实体中文名称
     *
     * @protected
     * @type {string}
     * @memberof MainGridBase
     */
    protected appDeLogicName: string = '合同信息';

    /**
     * 界面UI服务对象
     *
     * @type {HRContractUIService}
     * @memberof MainBase
     */  
    public appUIService:HRContractUIService = new HRContractUIService(this.$store);

    /**
     * 界面行为模型
     *
     * @type {*}
     * @memberof MainBase
     */  
    public ActionModel: any = {
    };

    /**
     * 本地缓存标识
     *
     * @protected
     * @type {string}
     * @memberof MainBase
     */
    protected localStorageTag: string = 'hrcontract_main_grid';

    /**
     * 所有列成员
     *
     * @type {any[]}
     * @memberof MainGridBase
     */
    public allColumns: any[] = [
        {
            name: 'contractcode',
            label: '合同编号',
            langtag: 'entities.hrcontract.main_grid.columns.contractcode',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'contractmode',
            label: '合同类别',
            langtag: 'entities.hrcontract.main_grid.columns.contractmode',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'contracttype',
            label: '合同类型',
            langtag: 'entities.hrcontract.main_grid.columns.contracttype',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'begintime',
            label: '开始日期',
            langtag: 'entities.hrcontract.main_grid.columns.begintime',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'endtime',
            label: '结束日期',
            langtag: 'entities.hrcontract.main_grid.columns.endtime',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'mgrorganizationname',
            label: '合同管理单位',
            langtag: 'entities.hrcontract.main_grid.columns.mgrorganizationname',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'signorganizationname',
            label: '合同签约单位',
            langtag: 'entities.hrcontract.main_grid.columns.signorganizationname',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'contractstate',
            label: '合同状态',
            langtag: 'entities.hrcontract.main_grid.columns.contractstate',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
    ]

    /**
     * 获取表格行模型
     *
     * @type {*}
     * @memberof MainGridBase
     */
    public getGridRowModel(){
        return {
          srfkey: new FormItemModel(),
        }
    }

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof MainGridBase
     */
    public rules: any = {
        srfkey: [
            { required: false, validator: (rule:any, value:any, callback:any) => { return (rule.required && (value === null || value === undefined || value === "")) ? false : true;}, message: '合同信息标识 值不能为空', trigger: 'change' },
            { required: false, validator: (rule:any, value:any, callback:any) => { return (rule.required && (value === null || value === undefined || value === "")) ? false : true;}, message: '合同信息标识 值不能为空', trigger: 'blur' },
        ],
    }

    /**
     * 获取对应列class
     *
     * @type {*}
     * @memberof MainBase
     */
    public hasRowEdit: any = {
        'contractcode':false,
        'contractmode':false,
        'contracttype':false,
        'begintime':false,
        'endtime':false,
        'mgrorganizationname':false,
        'signorganizationname':false,
        'contractstate':false,
    };

    /**
     * 获取对应列class
     *
     * @param {*} $args row 行数据，column 列数据，rowIndex 行索引，列索引
     * @returns {void}
     * @memberof MainBase
     */
    public getCellClassName(args: {row: any, column: any, rowIndex: number, columnIndex: number}): any {
        return ( this.hasRowEdit[args.column.property] && this.actualIsOpenEdit ) ? "edit-cell" : "info-cell";
    }


    /**
     * 导出数据格式化
     *
     * @param {*} filterVal
     * @param {*} jsonData
     * @param {any[]} [codelistColumns=[]]
     * @returns {Promise<any>}
     * @memberof MainGridBase
     */
    public async formatExcelData(filterVal: any, jsonData: any, codelistColumns?: any[]): Promise<any> {
        return super.formatExcelData(filterVal, jsonData, [
            {
                name: 'contractmode',
                srfkey: 'CL_HR_0021',
                codelistType : 'STATIC',
                renderMode: 'other',
                textSeparator: '、',
                valueSeparator: ',',
            },
            {
                name: 'contracttype',
                srfkey: 'CL_HR_0022',
                codelistType : 'STATIC',
                renderMode: 'other',
                textSeparator: '、',
                valueSeparator: ',',
            },
            {
                name: 'contractstate',
                srfkey: 'CL_HR_0019',
                codelistType : 'STATIC',
                renderMode: 'other',
                textSeparator: '、',
                valueSeparator: ',',
            },
        ]);
    }

}