/**
 * Active 部件模型
 *
 * @export
 * @class ActiveModel
 */
export default class ActiveModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof ActiveGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof ActiveGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'endtime',
          prop: 'endtime',
          dataType: 'DATE',
        },
        {
          name: 'mgrorganizationname',
          prop: 'mgrorganizationname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'contractcode',
          prop: 'contractcode',
          dataType: 'TEXT',
        },
        {
          name: 'begintime',
          prop: 'begintime',
          dataType: 'DATE',
        },
        {
          name: 'mgrorganizationid',
          prop: 'mgrorganizationid',
          dataType: 'PICKUP',
        },
        {
          name: 'srfmajortext',
          prop: 'hrcontractname',
          dataType: 'TEXT',
        },
        {
          name: 'srfkey',
          prop: 'hrcontractid',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'srfdataaccaction',
          prop: 'hrcontractid',
          dataType: 'GUID',
        },
        {
          name: 'signorganizationid',
          prop: 'signorganizationid',
          dataType: 'PICKUP',
        },
        {
          name: 'hremployeeid',
          prop: 'hremployeeid',
          dataType: 'PICKUP',
        },
        {
          name: 'contracttype',
          prop: 'contracttype',
          dataType: 'SSCODELIST',
        },
        {
          name: 'contractstate',
          prop: 'contractstate',
          dataType: 'SSCODELIST',
        },
        {
          name: 'signorganizationname',
          prop: 'signorganizationname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'contractmode',
          prop: 'contractmode',
          dataType: 'SSCODELIST',
        },
        {
          name: 'hrcontract',
          prop: 'hrcontractid',
        },

        {
          name:'size',
          prop:'size'
        },
        {
          name:'query',
          prop:'query'
        },
        {
          name:'filter',
          prop:'filter'
        },
        {
          name:'page',
          prop:'page'
        },
        {
          name:'sort',
          prop:'sort'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}