import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, GridControlBase } from '@/studio-core';
import HRContractService from '@/service/hrcontract/hrcontract-service';
import ActiveService from './active-grid-service';
import HRContractUIService from '@/uiservice/hrcontract/hrcontract-ui-service';
import { FormItemModel } from '@/model/form-detail';


/**
 * grid部件基类
 *
 * @export
 * @class GridControlBase
 * @extends {ActiveGridBase}
 */
export class ActiveGridBase extends GridControlBase {

    /**
     * 获取部件类型
     *
     * @protected
     * @type {string}
     * @memberof ActiveGridBase
     */
    protected controlType: string = 'GRID';

    /**
     * 建构部件服务对象
     *
     * @type {ActiveService}
     * @memberof ActiveGridBase
     */
    public service: ActiveService = new ActiveService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {HRContractService}
     * @memberof ActiveGridBase
     */
    public appEntityService: HRContractService = new HRContractService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof ActiveGridBase
     */
    protected appDeName: string = 'hrcontract';

    /**
     * 应用实体中文名称
     *
     * @protected
     * @type {string}
     * @memberof ActiveGridBase
     */
    protected appDeLogicName: string = '合同信息';

    /**
     * 逻辑事件
     *
     * @param {*} [params={}]
     * @param {*} [tag]
     * @param {*} [$event]
     * @memberof 
     */
    public grid_uagridcolumn1_u8163855_click(params: any = {}, tag?: any, $event?: any) {
        // 取数
        let datas: any[] = [];
        let xData: any = null;
        // _this 指向容器对象
        const _this: any = this;
        let paramJO:any = {};
        let contextJO:any = {};
        xData = this;
        if (_this.getDatas && _this.getDatas instanceof Function) {
            datas = [..._this.getDatas()];
        }
        if(params){
          datas = [params];
        }
        // 界面行为
        const curUIService:HRContractUIService  = new HRContractUIService();
        curUIService.HRContract_Stop(datas,contextJO, paramJO,  $event, xData,this,"HRContract");
    }

    /**
     * 界面UI服务对象
     *
     * @type {HRContractUIService}
     * @memberof ActiveBase
     */  
    public appUIService:HRContractUIService = new HRContractUIService(this.$store);

    /**
     * 界面行为模型
     *
     * @type {*}
     * @memberof ActiveBase
     */  
    public ActionModel: any = {
        Stop: { name: 'Stop',disabled: false, visabled: true,noprivdisplaymode:2,dataaccaction: '', target: 'SINGLEKEY'}
    };

    /**
     * 本地缓存标识
     *
     * @protected
     * @type {string}
     * @memberof ActiveBase
     */
    protected localStorageTag: string = 'hrcontract_active_grid';

    /**
     * 所有列成员
     *
     * @type {any[]}
     * @memberof ActiveGridBase
     */
    public allColumns: any[] = [
        {
            name: 'contractcode',
            label: '合同编号',
            langtag: 'entities.hrcontract.active_grid.columns.contractcode',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'contractmode',
            label: '合同类别',
            langtag: 'entities.hrcontract.active_grid.columns.contractmode',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'contracttype',
            label: '合同类型',
            langtag: 'entities.hrcontract.active_grid.columns.contracttype',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'begintime',
            label: '开始日期',
            langtag: 'entities.hrcontract.active_grid.columns.begintime',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'endtime',
            label: '结束日期',
            langtag: 'entities.hrcontract.active_grid.columns.endtime',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'mgrorganizationname',
            label: '合同管理单位',
            langtag: 'entities.hrcontract.active_grid.columns.mgrorganizationname',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'signorganizationname',
            label: '合同签约单位',
            langtag: 'entities.hrcontract.active_grid.columns.signorganizationname',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'contractstate',
            label: '合同状态',
            langtag: 'entities.hrcontract.active_grid.columns.contractstate',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'uagridcolumn1',
            label: '操作',
            langtag: 'entities.hrcontract.active_grid.columns.uagridcolumn1',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
    ]

    /**
     * 获取表格行模型
     *
     * @type {*}
     * @memberof ActiveGridBase
     */
    public getGridRowModel(){
        return {
          srfkey: new FormItemModel(),
        }
    }

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof ActiveGridBase
     */
    public rules: any = {
        srfkey: [
            { required: false, validator: (rule:any, value:any, callback:any) => { return (rule.required && (value === null || value === undefined || value === "")) ? false : true;}, message: '合同信息标识 值不能为空', trigger: 'change' },
            { required: false, validator: (rule:any, value:any, callback:any) => { return (rule.required && (value === null || value === undefined || value === "")) ? false : true;}, message: '合同信息标识 值不能为空', trigger: 'blur' },
        ],
    }

    /**
     * 获取对应列class
     *
     * @type {*}
     * @memberof ActiveBase
     */
    public hasRowEdit: any = {
        'contractcode':false,
        'contractmode':false,
        'contracttype':false,
        'begintime':false,
        'endtime':false,
        'mgrorganizationname':false,
        'signorganizationname':false,
        'contractstate':false,
        'uagridcolumn1':false,
    };

    /**
     * 获取对应列class
     *
     * @param {*} $args row 行数据，column 列数据，rowIndex 行索引，列索引
     * @returns {void}
     * @memberof ActiveBase
     */
    public getCellClassName(args: {row: any, column: any, rowIndex: number, columnIndex: number}): any {
        return ( this.hasRowEdit[args.column.property] && this.actualIsOpenEdit ) ? "edit-cell" : "info-cell";
    }


    /**
     * 导出数据格式化
     *
     * @param {*} filterVal
     * @param {*} jsonData
     * @param {any[]} [codelistColumns=[]]
     * @returns {Promise<any>}
     * @memberof ActiveGridBase
     */
    public async formatExcelData(filterVal: any, jsonData: any, codelistColumns?: any[]): Promise<any> {
        return super.formatExcelData(filterVal, jsonData, [
            {
                name: 'contractmode',
                srfkey: 'CL_HR_0021',
                codelistType : 'STATIC',
                renderMode: 'other',
                textSeparator: '、',
                valueSeparator: ',',
            },
            {
                name: 'contracttype',
                srfkey: 'CL_HR_0022',
                codelistType : 'STATIC',
                renderMode: 'other',
                textSeparator: '、',
                valueSeparator: ',',
            },
            {
                name: 'contractstate',
                srfkey: 'CL_HR_0019',
                codelistType : 'STATIC',
                renderMode: 'other',
                textSeparator: '、',
                valueSeparator: ',',
            },
        ]);
    }


    /**
     * 界面行为
     *
     * @param {*} row
     * @param {*} tag
     * @param {*} $event
     * @memberof ActiveGridBase
     */
	public uiAction(row: any, tag: any, $event: any): void {
        $event.stopPropagation();
        if(Object.is('Stop', tag)) {
            this.grid_uagridcolumn1_u8163855_click(row, tag, $event);
        }
    }
}