import AuthService from '../auth-service';

/**
 * 报价单权限服务对象基类
 *
 * @export
 * @class QuoteAuthServiceBase
 * @extends {AuthService}
 */
export default class QuoteAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  QuoteAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  QuoteAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof QuoteAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}