import AuthService from '../auth-service';

/**
 * 约会权限服务对象基类
 *
 * @export
 * @class AppointmentAuthServiceBase
 * @extends {AuthService}
 */
export default class AppointmentAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  AppointmentAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  AppointmentAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof AppointmentAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}